/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.excel.config.tmpl;

import cn.hutool.core.collection.CollUtil;
import com.elitescloud.boot.excel.common.DataImport;
import java.io.Serializable;
import java.lang.reflect.ParameterizedType;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DataImportServiceFactory {
    private static final Logger log = LoggerFactory.getLogger(DataImportServiceFactory.class);
    private final Map<String, ServiceMetaData> dataImportMap = new HashMap<String, ServiceMetaData>(64);

    public DataImportServiceFactory(List<DataImport<?>> dataImportList) {
        this.init(dataImportList);
    }

    public boolean isSupport(String tmplCode) {
        return this.dataImportMap.containsKey(tmplCode);
    }

    public ServiceMetaData getDataImportService(String tmplCode) {
        return this.dataImportMap.get(tmplCode);
    }

    private void init(List<DataImport<?>> dataImportList) {
        if (CollUtil.isEmpty(dataImportList)) {
            return;
        }
        for (DataImport<?> dataImport : dataImportList) {
            if (this.dataImportMap.containsKey(dataImport.getTmplCode())) {
                throw new IllegalStateException("\u5b58\u5728\u91cd\u590d\u7684\u6570\u636e\u5bfc\u5165\u670d\u52a1\uff1a" + dataImport.getTmplCode());
            }
            this.dataImportMap.put(dataImport.getTmplCode(), new ServiceMetaData(dataImport));
        }
    }

    public static class ServiceMetaData {
        private final DataImport<Serializable> dataImport;
        private final Class<?> dataType;

        public ServiceMetaData(DataImport<?> dataImport) {
            this.dataImport = dataImport;
            this.dataType = (Class)((ParameterizedType)dataImport.getClass().getGenericInterfaces()[0]).getActualTypeArguments()[0];
        }

        public DataImport<Serializable> getDataImport() {
            return this.dataImport;
        }

        public Class<?> getDataType() {
            return this.dataType;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ServiceMetaData)) {
                return false;
            }
            ServiceMetaData other = (ServiceMetaData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            DataImport<Serializable> this$dataImport = this.getDataImport();
            DataImport<Serializable> other$dataImport = other.getDataImport();
            if (this$dataImport == null ? other$dataImport != null : !this$dataImport.equals(other$dataImport)) {
                return false;
            }
            Class<?> this$dataType = this.getDataType();
            Class<?> other$dataType = other.getDataType();
            return !(this$dataType == null ? other$dataType != null : !this$dataType.equals(other$dataType));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ServiceMetaData;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            DataImport<Serializable> $dataImport = this.getDataImport();
            result = result * 59 + ($dataImport == null ? 43 : $dataImport.hashCode());
            Class<?> $dataType = this.getDataType();
            result = result * 59 + ($dataType == null ? 43 : $dataType.hashCode());
            return result;
        }

        public String toString() {
            return "DataImportServiceFactory.ServiceMetaData(dataImport=" + this.getDataImport() + ", dataType=" + this.getDataType() + ")";
        }
    }
}

