/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.excel.config.tmpl.export.strategy;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.el.coordinator.boot.fsm.service.FileService;
import com.elitescloud.boot.common.param.AbstractOrderQueryParam;
import com.elitescloud.boot.excel.config.tmpl.export.ExportStrategyParam;
import com.elitescloud.boot.excel.config.tmpl.export.SystemTmplDataSupport;
import com.elitescloud.boot.excel.config.tmpl.export.strategy.BaseExportStrategy;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.dto.SysImportRateDTO;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.Serializable;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StopWatch;

class IgnoreExportStrategy<R extends Serializable, P extends AbstractOrderQueryParam>
extends BaseExportStrategy<R, P> {
    private static final Logger LOG = LoggerFactory.getLogger(IgnoreExportStrategy.class);

    public IgnoreExportStrategy(FileService<?> fileService, SystemTmplDataSupport fsmTmplSupport, ObjectMapper objectMapper) {
        super(fileService, fsmTmplSupport, objectMapper);
    }

    @Override
    public long export(ExportStrategyParam<R, P> param) {
        int sheetLimit = this.sheetLimit(param.getTmplDTO());
        int page = 2;
        int pageSize = param.getPageSize();
        int count = 0;
        File excelFile = this.createExportFile(param);
        StopWatch watch = new StopWatch();
        watch.start();
        ExcelWriter excelWriter = EasyExcel.write((File)excelFile).build();
        WriteSheet sheet = EasyExcel.writerSheet((Integer)0).sheetName("Sheet 1").build();
        excelWriter.write(this.obtainHeaders(param.getTmplDTO()), sheet);
        PagingVO<R> pageData = param.getFirstPageData();
        List<String> attributes = this.obtainAttributes(param.getTmplDTO());
        while (pageData.isNotEmpty()) {
            boolean isFinish;
            List tempDataList = pageData.getRecords();
            if (count + pageData.size() > sheetLimit) {
                tempDataList = pageData.getRecords().subList(0, sheetLimit - count);
            }
            List<List<String>> writeDataList = this.convertExportData(tempDataList, attributes);
            excelWriter.write(writeDataList, sheet);
            boolean bl = isFinish = pageData.size() < pageSize || (count += tempDataList.size()) == sheetLimit;
            if (!param.isSync()) {
                super.updateRate(param.getImportId(), SysImportRateDTO.builder().finish(false).total(pageData.getTotal()).count((long)count - 1L).tmplCode(param.getTmplDTO().getCode()).build());
            }
            if (isFinish) break;
            param.getQueryParam().setCurrent(Integer.valueOf(page));
            param.getQueryParam().setSize(Integer.valueOf(pageSize));
            pageData = param.getDataProvider().apply(param.getQueryParam());
            ++page;
        }
        excelWriter.finish();
        watch.stop();
        this.updateExportFinish(param, Long.valueOf(count), "\u5bfc\u51fa\u6210\u529f", excelFile);
        LOG.info(param.getImportId() + "\u5bfc\u51fa\u7ed3\u675f\u8017\u65f6\uff1a" + watch.getTotalTimeMillis());
        excelFile.deleteOnExit();
        return count;
    }
}

