package com.elitescloud.boot.excel.common;

import com.elitescloud.boot.excel.common.param.AbstractExportQueryParam;
import com.elitescloud.cloudt.common.base.PagingVO;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;

/**
 * excel导出服务.
 *
 * @author Kaiser（wang shao）
 * @date 2021/09/18
 */
public interface ExportExcelService<T extends AbstractExportQueryParam, R extends Serializable, E extends Serializable> {

    /**
     * 同步数据导出
     *
     * @param queryParam  查询数据参数
     * @param response    response
     * @param dataService 查询数据服务
     * @return 是否执行完毕
     */
    Boolean exportSync(T queryParam, HttpServletResponse response, Function<T, PagingVO<R>> dataService);

    /**
     * 异步数据导出
     *
     * @param queryParam  查询数据参数
     * @param response    response
     * @param dataService 查询数据服务
     * @return 是否执行完毕
     */
    CompletableFuture<Boolean> export(T queryParam, HttpServletResponse response, Function<T, PagingVO<R>> dataService);

    /**
     * 同步数据导出（包含明细）
     *
     * @param queryParam  查询数据参数
     * @param response    response
     * @param dataService 查询数据服务
     * @param detailData  获取明细数据
     * @return 是否执行完毕
     */
    Boolean exportSync(T queryParam, HttpServletResponse response, Function<T, PagingVO<R>> dataService, Function<R, List<E>> detailData);

    /**
     * 异步数据导出（包含明细）
     *
     * @param queryParam  查询数据参数
     * @param response    response
     * @param dataService 查询数据服务
     * @param detailData  获取明细数据
     * @return 是否执行完毕
     */
    CompletableFuture<Boolean> export(T queryParam, HttpServletResponse response, Function<T, PagingVO<R>> dataService, Function<R, List<E>> detailData);
}
