package com.elitescloud.cloudt.system.dto.resp;

import cn.hutool.core.util.ObjectUtil;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Builder;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * 导入结果.
 *
 * @author Kaiser（wang shao）
 * @date 2021-05-11
 */
@Data
@ApiModel(description = "导入结果")
@Builder
public class ImportResultRespVO implements Serializable {
    private static final long serialVersionUID = -2819268049473549541L;

    /**
     * 是否是同步导入
     */
    @ApiModelProperty(value = "是否是同步导入", position = 1)
    private Boolean sync;

    /**
     * 同步导入结果
     */
    @ApiModelProperty(value = "同步导入结果", position = 2)
    private SyncResult syncResult;

    /**
     * 异步导入结果
     */
    @ApiModelProperty(value = "异步导入结果", position = 3)
    private AsyncResult asyncResult;

    /**
     * 同步导入结果
     */
    @Data
    @ApiModel(value = "cloudt_ImportResult_SyncResult", description = "同步导入结果")
    @Builder
    public static class SyncResult implements Serializable {

        private static final long serialVersionUID = 5467202772116021540L;

        /**
         * 导入总数
         */
        @ApiModelProperty(value = "导入总数", position = 1)
        private Integer total;

        /**
         * 导入成功数量
         * <p>
         * 默认为total
         */
        @ApiModelProperty(value = "导入成功数量", position = 2)
        private Integer numSuccess;

        /**
         * 导入失败数量
         * <p>
         * 默认为total - numSuccess
         */
        @ApiModelProperty(value = "导入失败数量", position = 3)
        private Integer numFail;

        /**
         * 导入失败的文件编码
         */
        @ApiModelProperty(value = "导入失败的文件编码", position = 4)
        private String failFileCode;

        /**
         * 导入失败原因
         * <p>
         * 成功的请设置成null，失败的设置失败原因，集合的大小应等于total
         */
        @ApiModelProperty(value = "导入失败原因，按需返回", position = 5)
        private List<String> failRecords;

        /**
         * 导入成功的记录
         */
        @ApiModelProperty(value = "导入成功的记录，按需返回", position = 6)
        private List<? extends Serializable> dataSuccess;

        /**
         * 导入成功的记录
         */
        @ApiModelProperty(value = "导入失败的记录，按需返回", position = 7)
        private List<? extends Serializable> dataFail;

        public Integer getNumFail() {
            if (numFail == null) {
                return ObjectUtil.defaultIfNull(total, 0) - ObjectUtil.defaultIfNull(numSuccess, 0);
            }
            return numFail;
        }
    }

    /**
     * 异步导入结果
     */
    @Data
    @ApiModel(value = "cloudt_ImportResult_AsyncResult", description = "异步导入结果")
    @Builder
    public static class AsyncResult implements Serializable {

        private static final long serialVersionUID = -8128558468641849223L;

        /**
         * 导入记录标识
         */
        @ApiModelProperty(value = "导入记录标识")
        private Long importId;
    }
}
