/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.excel.config.tmpl;

import cn.hutool.core.collection.CollUtil;
import com.elitescloud.boot.common.param.AbstractOrderQueryParam;
import com.elitescloud.boot.excel.common.DataExport;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.PagingVO;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

class DataExportServiceFactory {
    private static final Logger log = LoggerFactory.getLogger(DataExportServiceFactory.class);
    private final Map<String, ServiceMetaData> dataExportMap = new HashMap<String, ServiceMetaData>(64);

    public DataExportServiceFactory(List<DataExport<?, ?>> dataExportList) {
        this.init(dataExportList);
    }

    public boolean isSupport(String tmplCode) {
        return this.dataExportMap.containsKey(tmplCode);
    }

    public ServiceMetaData getDataExportService(String tmplCode) {
        return this.dataExportMap.get(tmplCode);
    }

    private void init(List<DataExport<? extends Serializable, ? extends AbstractOrderQueryParam>> dataExportList) {
        if (CollUtil.isEmpty(dataExportList)) {
            return;
        }
        for (DataExport<? extends Serializable, ? extends AbstractOrderQueryParam> dataExport : dataExportList) {
            if (!this.dataExportMap.containsKey(dataExport.getTmplCode())) continue;
            throw new BusinessException("\u5b58\u5728\u91cd\u590d\u7684\u6570\u636e\u5bfc\u51fa\u670d\u52a1\uff1a" + dataExport.getTmplCode());
        }
        CompletableFuture.runAsync(() -> {
            for (DataExport dataExport : dataExportList) {
                this.dataExportMap.put(dataExport.getTmplCode(), new ServiceMetaData(dataExport));
            }
        }).whenComplete((r, e) -> {
            if (e != null) {
                log.error("\u521d\u59cb\u5316\u6570\u636e\u5bfc\u51fa\u670d\u52a1\u5f02\u5e38\uff1a", e);
                return;
            }
            log.info("initialized DataExportService\uff1a{}", (Object)String.join((CharSequence)",", this.dataExportMap.keySet()));
        });
    }

    public static class ServiceMetaData {
        private final Object dataExport;
        private final Class<? extends Serializable> dataType;
        private final Class<? extends AbstractOrderQueryParam> paramType;
        private final Method exportMethod;
        private final Method exportMethodCompatible;

        public <T extends DataExport<R, P>, R extends Serializable, P extends AbstractOrderQueryParam> ServiceMetaData(T dataExport) {
            this.dataExport = dataExport;
            Type[] arguments = ((ParameterizedType)dataExport.getClass().getGenericInterfaces()[0]).getActualTypeArguments();
            this.dataType = (Class)arguments[0];
            this.paramType = (Class)arguments[1];
            this.exportMethod = this.obtainExportMethod(dataExport, this.paramType);
            this.exportMethodCompatible = this.obtainExportMethodCompatible(dataExport, this.paramType);
            Assert.isTrue((this.exportMethod != null || this.exportMethodCompatible != null ? 1 : 0) != 0, (String)"\u672a\u627e\u5230\u5bfc\u51fa\u6570\u636e\u7684executeExport\u65b9\u6cd5");
        }

        public <R extends Serializable, P extends AbstractOrderQueryParam> PagingVO<R> applyExport(P params) {
            try {
                if (this.exportMethod != null) {
                    return (PagingVO)this.exportMethod.invoke(this.dataExport, params);
                }
                if (this.exportMethodCompatible != null) {
                    return (PagingVO)this.exportMethodCompatible.invoke(this.dataExport, params, params.getCurrent() + 1, params.getSize());
                }
            }
            catch (Throwable e) {
                throw new BusinessException("\u5bfc\u51fa\u6570\u636e\u5f02\u5e38", e);
            }
            log.error("\u5728{}\u4e2d\u672a\u53d1\u73b0\u6709\u6548\u7684\u5bfc\u51fa\u65b9\u6cd5executeExport()", (Object)this.dataExport.getClass().getName());
            return PagingVO.empty();
        }

        public <P extends AbstractOrderQueryParam> Class<P> applyGetParamType() {
            return this.paramType;
        }

        public String applyGetExportFileName() {
            return ((DataExport)this.dataExport).exportFileName();
        }

        public int applyGetPageSize() {
            Integer pageSize = ((DataExport)this.dataExport).pageSize();
            if (pageSize == null || pageSize < 1) {
                return 50;
            }
            return pageSize;
        }

        public boolean applyIsRequiredTmpl() {
            return Boolean.TRUE.equals(((DataExport)this.dataExport).requireTmpl());
        }

        private Method obtainExportMethod(Object dataExport, Class<?> paramType) {
            try {
                return dataExport.getClass().getMethod("executeExport", paramType);
            }
            catch (Throwable throwable) {
                return null;
            }
        }

        private Method obtainExportMethodCompatible(Object dataExport, Class<?> paramType) {
            try {
                return dataExport.getClass().getMethod("execute", paramType, Integer.TYPE, Integer.TYPE);
            }
            catch (Throwable throwable) {
                return null;
            }
        }
    }
}

