package com.elitescloud.boot.excel.config.tmpl.converter;

import cn.hutool.core.text.CharSequenceUtil;
import com.alibaba.excel.enums.CellDataTypeEnum;
import com.alibaba.excel.metadata.CellData;
import com.alibaba.excel.metadata.GlobalConfiguration;
import com.alibaba.excel.metadata.property.ExcelContentProperty;
import com.elitescloud.boot.excel.common.support.CustomConverter;
import com.elitescloud.boot.util.DatetimeUtil;

import java.util.Date;

/**
 * 日期转换器.
 *
 * @author Kaiser（wang shao）
 * @date 2024/1/16
 */
class DateConverter implements CustomConverter<Date> {

    @Override
    public Class<Date> supportJavaTypeKey() {
        return Date.class;
    }

    @Override
    public CellDataTypeEnum supportExcelTypeKey() {
        return CellDataTypeEnum.STRING;
    }

    @Override
    public Date convertToJavaData(CellData cellData, ExcelContentProperty contentProperty, GlobalConfiguration globalConfiguration) throws Exception {
        var strValue = cellData.getDataFormatString();
        return DatetimeUtil.parseForDatetime(strValue);
    }

    @Override
    public CellData<String> convertToExcelData(Date value, ExcelContentProperty contentProperty, GlobalConfiguration globalConfiguration) throws Exception {
        var strValue = value == null ? "" : DatetimeUtil.toStr(value);
        return new CellData<>(strValue);
    }
}
