package com.elitescloud.boot.excel.config.tmpl.export.strategy;

import com.el.coordinator.boot.fsm.service.FileService;
import com.el.coordinator.core.common.constant.SheetLimitStrategy;
import com.elitescloud.boot.common.param.AbstractOrderQueryParam;
import com.elitescloud.boot.excel.config.tmpl.export.ExportStrategyParam;
import com.elitescloud.boot.excel.config.tmpl.export.SystemTmplDataSupport;
import com.elitescloud.boot.excel.util.ExcelUtil;
import com.elitescloud.boot.util.ObjectMapperFactory;
import com.elitescloud.cloudt.system.dto.SysTmplDTO;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ser.std.NumberSerializers;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2022/11/28
 */
public class TmplExportStrategyDelegate<R extends Serializable, P extends AbstractOrderQueryParam> implements ExportStrategy<R, P> {
    private final Map<SheetLimitStrategy, Constructor> strategyMap = new HashMap<>();

    private final FileService<?> fileService;
    private final SystemTmplDataSupport fsmTmplSupport;
    private final ObjectMapper objectMapper;

    public TmplExportStrategyDelegate(FileService<?> fileService, SystemTmplDataSupport fsmTmplSupport) {
        this.fileService = fileService;
        this.fsmTmplSupport = fsmTmplSupport;
        this.objectMapper = ExcelUtil.buildObjectMapper();

        this.init();
    }

    @Override
    public long export(ExportStrategyParam<R, P> param) {
        // 获取sheet策略
        SheetLimitStrategy sheetLimitStrategy = obtainSheetStrategy(param.getTmplDTO());
        Constructor<? extends ExportStrategy<R, P>> strategyClazz = strategyMap.get(sheetLimitStrategy);
        Assert.notNull(strategyClazz, "暂不支持的导出策略");

        ExportStrategy<R, P> exportStrategy = null;
        try {
            exportStrategy = strategyClazz.newInstance(fileService, fsmTmplSupport, objectMapper);
        } catch (Throwable e) {
            throw new IllegalStateException("实例化导出策略异常", e);
        }

        return exportStrategy.export(param);
    }

    private SheetLimitStrategy obtainSheetStrategy(SysTmplDTO tmplDTO) {
        if (!StringUtils.hasText(tmplDTO.getExportSheetStrategy())) {
            return SheetLimitStrategy.NEW_SHEET;
        }

        return SheetLimitStrategy.valueOf(tmplDTO.getExportSheetStrategy());
    }

    private void init() {
        try {
            Class<?>[] classes = {FileService.class, SystemTmplDataSupport.class, ObjectMapper.class};
            strategyMap.put(SheetLimitStrategy.IGNORE, IgnoreExportStrategy.class.getDeclaredConstructor(classes));
            strategyMap.put(SheetLimitStrategy.NEW_SHEET, NewSheetExportStrategy.class.getDeclaredConstructor(classes));
            strategyMap.put(SheetLimitStrategy.NEW_FILE, NewFileExportStrategy.class.getDeclaredConstructor(classes));
        } catch (NoSuchMethodException e) {
            throw new IllegalStateException("导出策略实现类缺少指定的构造方法", e);
        }
    }
}
