/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.excel.config.tmpl;

import cn.hutool.core.collection.CollUtil;
import com.elitescloud.boot.common.param.AbstractOrderQueryParam;
import com.elitescloud.boot.excel.common.DataExport;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.PagingVO;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

class DataExportServiceFactory {
    private static final Logger log = LoggerFactory.getLogger(DataExportServiceFactory.class);
    private final Map<String, ServiceMetaData> dataExportMap = new HashMap<String, ServiceMetaData>(64);

    public DataExportServiceFactory(List<DataExport<?, ?>> dataExportList) {
        this.init(dataExportList);
    }

    public boolean isSupport(String tmplCode) {
        return this.dataExportMap.containsKey(tmplCode);
    }

    public ServiceMetaData getDataExportService(String tmplCode) {
        return this.dataExportMap.get(tmplCode);
    }

    private void init(List<DataExport<? extends Serializable, ? extends AbstractOrderQueryParam>> dataExportList) {
        if (CollUtil.isEmpty(dataExportList)) {
            return;
        }
        for (DataExport<? extends Serializable, ? extends AbstractOrderQueryParam> dataExport : dataExportList) {
            if (!this.dataExportMap.containsKey(dataExport.getTmplCode())) continue;
            throw new BusinessException("\u5b58\u5728\u91cd\u590d\u7684\u6570\u636e\u5bfc\u51fa\u670d\u52a1\uff1a" + dataExport.getTmplCode());
        }
        CompletableFuture.runAsync(() -> {
            for (DataExport dataExport : dataExportList) {
                this.dataExportMap.put(dataExport.getTmplCode(), new ServiceMetaData(dataExport));
            }
        }).whenComplete((r, e) -> {
            if (e != null) {
                log.error("\u521d\u59cb\u5316\u6570\u636e\u5bfc\u51fa\u670d\u52a1\u5f02\u5e38\uff1a", e);
                return;
            }
            log.info("initialized DataExportService\uff1a{}", (Object)String.join((CharSequence)",", this.dataExportMap.keySet()));
        });
    }

    public static class ServiceMetaData {
        private final DataExport dataExport;
        private final Class<? extends Serializable> dataType;
        private final Class<? extends AbstractOrderQueryParam> paramType;
        private final boolean hasNewExportMethod;
        private final Method exportMethod;
        private final Method exportMethodCompatible;

        public <T extends DataExport<R, P>, R extends Serializable, P extends AbstractOrderQueryParam> ServiceMetaData(T dataExport) {
            this.dataExport = dataExport;
            Class<?> clazzDataExport = dataExport.getClass();
            Type[] arguments = ((ParameterizedType)clazzDataExport.getGenericInterfaces()[0]).getActualTypeArguments();
            this.dataType = (Class)arguments[0];
            this.paramType = (Class)arguments[1];
            this.exportMethod = this.obtainExportMethod(dataExport, this.paramType);
            this.exportMethodCompatible = this.obtainExportMethodCompatible(dataExport, this.paramType);
            Assert.isTrue((this.exportMethod != null || this.exportMethodCompatible != null ? 1 : 0) != 0, () -> dataExport.getClass().getName() + "\u672a\u627e\u5230\u5bfc\u51fa\u6570\u636e\u7684executeExport\u65b9\u6cd5");
            boolean bl = this.hasNewExportMethod = this.exportMethod != null;
            if (!this.hasNewExportMethod) {
                log.warn("{}\u4f7f\u7528\u4e86\u8fc7\u671f\u7684\u5bfc\u51fa\u65b9\u6cd5\uff0c\u8bf7\u5c3d\u5feb\u5207\u6362\u6210\u6700\u65b0\u7684\u5bfc\u51fa\u65b9\u6cd5executeExport()", (Object)clazzDataExport.getName());
            }
        }

        public <R extends Serializable, P extends AbstractOrderQueryParam> PagingVO<R> applyExport(P params, boolean useReflect) {
            try {
                if (useReflect) {
                    if (this.exportMethod != null) {
                        return (PagingVO)this.exportMethod.invoke((Object)this.dataExport, params);
                    }
                    if (this.exportMethodCompatible != null) {
                        return (PagingVO)this.exportMethodCompatible.invoke((Object)this.dataExport, params, params.getCurrent() + 1, params.getSize());
                    }
                }
                if (this.hasNewExportMethod) {
                    return this.dataExport.executeExport(params);
                }
                return this.dataExport.execute(params, params.getCurrent() + 1, params.getSize());
            }
            catch (Throwable e) {
                throw new BusinessException("\u5bfc\u51fa\u6570\u636e\u5f02\u5e38", e);
            }
        }

        public <P extends AbstractOrderQueryParam> Class<P> applyGetParamType() {
            return this.paramType;
        }

        public String applyGetExportFileName() {
            return this.dataExport.exportFileName();
        }

        public int applyGetPageSize() {
            Integer pageSize = this.dataExport.pageSize();
            if (pageSize == null || pageSize < 1) {
                return 50;
            }
            return pageSize;
        }

        public boolean applyIsRequiredTmpl() {
            return Boolean.TRUE.equals(this.dataExport.requireTmpl());
        }

        private boolean detectedHasNewExportMethod(Class<?> clazz, Class<?> paramType) {
            try {
                clazz.getDeclaredMethod("executeExport", paramType);
                return true;
            }
            catch (NoSuchMethodException e) {
                return false;
            }
        }

        private Method obtainExportMethod(Object dataExport, Class<?> paramType) {
            try {
                return dataExport.getClass().getDeclaredMethod("executeExport", paramType);
            }
            catch (Throwable throwable) {
                return null;
            }
        }

        private Method obtainExportMethodCompatible(Object dataExport, Class<?> paramType) {
            try {
                return dataExport.getClass().getDeclaredMethod("execute", paramType, Integer.TYPE, Integer.TYPE);
            }
            catch (Throwable throwable) {
                return null;
            }
        }
    }
}

