/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.excel.config.tmpl.export.strategy;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.el.coordinator.boot.fsm.service.FileService;
import com.elitescloud.boot.common.param.AbstractOrderQueryParam;
import com.elitescloud.boot.excel.config.tmpl.export.ExportStrategyParam;
import com.elitescloud.boot.excel.config.tmpl.export.SystemTmplDataSupport;
import com.elitescloud.boot.excel.config.tmpl.export.strategy.BaseExportStrategy;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.dto.SysImportRateDTO;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.Serializable;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class IgnoreExportStrategy<R extends Serializable, P extends AbstractOrderQueryParam>
extends BaseExportStrategy<R, P> {
    private static final Logger LOG = LoggerFactory.getLogger(IgnoreExportStrategy.class);

    public IgnoreExportStrategy(FileService<?> fileService, SystemTmplDataSupport fsmTmplSupport, ObjectMapper objectMapper) {
        super(fileService, fsmTmplSupport, objectMapper);
    }

    @Override
    public long export(ExportStrategyParam<R, P> param) {
        int sheetLimit = this.sheetLimit(param.getTmplDTO());
        int page = 2;
        int pageSize = param.getPageSize();
        int count = 0;
        File excelFile = this.createExportFile(param);
        ExcelWriter excelWriter = super.createExcelWriter(excelFile);
        WriteSheet sheet = EasyExcel.writerSheet((Integer)0).sheetName("Sheet 1").build();
        excelWriter.write(this.obtainHeaders(param.getTmplDTO()), sheet);
        PagingVO<R> pageData = param.getFirstPageData();
        List<String> attributes = this.obtainAttributes(param.getTmplDTO());
        param.getCostTime().getPrepare().stop();
        while (pageData.isNotEmpty()) {
            boolean isFinish;
            List tempDataList = pageData.getRecords();
            if (count + pageData.size() > sheetLimit) {
                tempDataList = pageData.getRecords().subList(0, sheetLimit - count);
            }
            super.convertAndWrite(excelWriter, sheet, attributes, tempDataList, param.getCostTime());
            boolean bl = isFinish = pageData.size() < pageSize || (count += tempDataList.size()) == sheetLimit;
            if (!param.isSync()) {
                param.getCostTime().getUpdateResult().start();
                super.updateRate(param.getImportId(), SysImportRateDTO.builder().finish(false).total(pageData.getTotal()).count((long)count - 1L).tmplCode(param.getTmplDTO().getCode()).build());
                param.getCostTime().getUpdateResult().stop();
            }
            if (isFinish) break;
            param.getCostTime().getQueryData().start();
            param.getQueryParam().setCurrent(Integer.valueOf(page));
            param.getQueryParam().setSize(Integer.valueOf(pageSize));
            pageData = param.getDataProvider().apply(param.getQueryParam());
            param.getCostTime().getQueryData().stop();
            ++page;
        }
        excelWriter.finish();
        param.getCostTime().getUpdateResult().start();
        this.updateExportFinish(param, Long.valueOf(count), excelFile, param.getCostTime());
        excelFile.deleteOnExit();
        param.getCostTime().getUpdateResult().stop();
        return count;
    }
}

