/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.excel.support;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ReflectUtil;
import com.elitescloud.boot.util.ArrayUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

public class ExcelBean {
    private static final Map<Class<?>, ExcelBean> CACHE = new HashMap(256);
    private final Class<?> clazz;
    private Map<String, BeanField> dataFieldMap;

    private ExcelBean(Class<?> clazz) {
        this.clazz = clazz;
        this.analyze();
    }

    public static ExcelBean getInstance(@NotNull Class<?> clazz) {
        return CACHE.computeIfAbsent(clazz, ExcelBean::new);
    }

    public BeanField getField(@NotBlank String fieldName) {
        return this.dataFieldMap.get(fieldName);
    }

    public List<Annotation> getAnnotations(@NotBlank String fieldName, Class<? extends Annotation> annotationType) {
        Map<Class<? extends Annotation>, List<Annotation>> annoMap = this.dataFieldMap.get(fieldName).getFieldAnnotationsMap();
        if (CollUtil.isEmpty(annoMap)) {
            return Collections.emptyList();
        }
        if (annotationType == null) {
            return annoMap.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
        }
        return annoMap.get(annotationType);
    }

    public <T extends Annotation> T getAnnotation(@NotBlank String fieldName, Class<T> annotationType) {
        List<Annotation> annotations = this.getAnnotations(fieldName, annotationType);
        return (T)(CollUtil.isEmpty(annotations) ? null : annotations.get(0));
    }

    private void analyze() {
        Map fields = ReflectUtil.getFieldMap(this.clazz);
        if (CollUtil.isEmpty((Map)fields)) {
            this.dataFieldMap = Collections.emptyMap();
            return;
        }
        this.dataFieldMap = new HashMap<String, BeanField>(fields.size());
        for (Map.Entry entry : fields.entrySet()) {
            this.dataFieldMap.put((String)entry.getKey(), this.buildBeanField((Field)entry.getValue()));
        }
    }

    private BeanField buildBeanField(Field field) {
        BeanField beanField = new BeanField();
        beanField.setName(field.getName());
        beanField.setField(field);
        Object[] annotationsAll = field.getAnnotations();
        Map<Class, List> fieldAnnotationsMap = null;
        if (ArrayUtil.isEmpty((Object[])annotationsAll)) {
            fieldAnnotationsMap = Collections.emptyMap();
        } else {
            fieldAnnotationsMap = new HashMap(annotationsAll.length);
            for (Object annotation : annotationsAll) {
                fieldAnnotationsMap.computeIfAbsent(annotation.annotationType(), a -> new ArrayList(4)).add(annotation);
            }
        }
        beanField.setFieldAnnotationsMap(Collections.unmodifiableMap(fieldAnnotationsMap));
        return beanField;
    }

    public static class BeanField {
        private String name;
        private Field field;
        private Map<Class<? extends Annotation>, List<Annotation>> fieldAnnotationsMap;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public Field getField() {
            return this.field;
        }

        public void setField(Field field) {
            this.field = field;
        }

        public Map<Class<? extends Annotation>, List<Annotation>> getFieldAnnotationsMap() {
            return this.fieldAnnotationsMap;
        }

        public void setFieldAnnotationsMap(Map<Class<? extends Annotation>, List<Annotation>> fieldAnnotationsMap) {
            this.fieldAnnotationsMap = fieldAnnotationsMap;
        }
    }
}

