/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.excel.util;

import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.poi.excel.RowUtil;
import cn.hutool.poi.excel.cell.CellUtil;
import cn.hutool.poi.excel.style.StyleUtil;
import com.alibaba.excel.converters.Converter;
import com.alibaba.excel.write.builder.ExcelWriterBuilder;
import com.elitescloud.boot.common.annotation.BigDecimalFormat;
import com.elitescloud.boot.excel.config.tmpl.converter.ConverterFactory;
import com.elitescloud.boot.excel.support.ExcelBean;
import com.elitescloud.boot.provider.DataFormatterProvider;
import com.elitescloud.boot.util.ObjectMapperFactory;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ser.std.NumberSerializers;
import java.math.BigDecimal;
import java.util.List;
import org.apache.poi.ss.SpreadsheetVersion;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;
import org.springframework.lang.NonNull;
import org.springframework.util.Assert;

public final class ExcelUtil
extends cn.hutool.poi.excel.ExcelUtil {
    private static final Logger LOG = LoggerFactory.getLogger(ExcelUtil.class);
    private static List<Converter<?>> converters;

    private ExcelUtil() {
    }

    public static void copyRows(@NonNull Sheet source, @NonNull Sheet target, int startIndex, int endIndex, Integer cellNum) {
        Assert.isTrue((endIndex > startIndex ? 1 : 0) != 0, (String)"endIndex\u5fc5\u987b\u5927\u4e8estartIndex");
        int startRowNum = source.getFirstRowNum();
        int endRowNum = source.getLastRowNum();
        if (startIndex > endRowNum || endIndex < startRowNum) {
            LOG.warn("\u6ca1\u6709\u53ef\u590d\u5236\u7684\u884c\u6570\uff1a{}-{}, {}-{}", new Object[]{startIndex, endIndex, startRowNum, endRowNum});
            return;
        }
        if (cellNum != null && cellNum < 1) {
            LOG.warn("\u6ca1\u6709\u53ef\u590d\u5236\u7684\u5217\uff1a{}", (Object)cellNum);
            return;
        }
        for (int i = startIndex; i <= endIndex; ++i) {
            int colNum;
            Row sourceRow = source.getRow(i);
            int n = sourceRow == null ? -1 : (colNum = cellNum == null ? (int)sourceRow.getLastCellNum() : cellNum);
            if (colNum < 1) continue;
            Row targetRow = RowUtil.getOrCreateRow((Sheet)target, (int)i);
            for (int j = sourceRow.getFirstCellNum(); j < colNum; ++j) {
                Cell sourceCell = sourceRow.getCell(j);
                if (sourceCell == null) continue;
                Cell targetCell = CellUtil.getOrCreateCell((Row)targetRow, (int)j);
                targetCell.setCellValue(sourceCell.getStringCellValue());
                targetCell.setCellStyle(StyleUtil.cloneCellStyle((Cell)targetCell, (CellStyle)sourceCell.getCellStyle()));
            }
        }
    }

    public static ObjectMapper buildObjectMapper() {
        Jackson2ObjectMapperBuilder objectMapperBuilder = ObjectMapperFactory.builderInstance();
        objectMapperBuilder.serializerByType(Long.class, (JsonSerializer)new NumberSerializers.LongSerializer(Long.class));
        objectMapperBuilder.serializerByType(Long.TYPE, (JsonSerializer)new NumberSerializers.LongSerializer(Long.TYPE));
        return objectMapperBuilder.build();
    }

    public static ExcelWriterBuilder normalizeExcelWriter(ExcelWriterBuilder writerBuilder) {
        ((ExcelWriterBuilder)((ExcelWriterBuilder)writerBuilder.useDefaultStyle(Boolean.valueOf(true))).autoTrim(Boolean.valueOf(true))).writeExcelOnException(Boolean.valueOf(true));
        for (Converter<?> converter : ExcelUtil.getConverters()) {
            writerBuilder.registerConverter(converter);
        }
        return writerBuilder;
    }

    public static Object formatExportedValue(Object value, String field, Class<?> dataType) {
        if (value == null || CharSequenceUtil.isBlank((CharSequence)field) || dataType == null) {
            return value;
        }
        if (value instanceof String) {
            return CharSequenceUtil.subPre((CharSequence)value.toString(), (int)SpreadsheetVersion.EXCEL2007.getMaxTextLength());
        }
        if (value instanceof BigDecimal) {
            BigDecimalFormat bigDecimalFormat = ExcelBean.getInstance(dataType).getAnnotation(field, BigDecimalFormat.class);
            return DataFormatterProvider.getInstance().format((BigDecimal)value, bigDecimalFormat);
        }
        return value;
    }

    public static List<Converter<?>> getConverters() {
        if (converters == null) {
            converters = ConverterFactory.getConvertersAll();
        }
        return converters;
    }
}

