package com.elitescloud.boot.excel.common;

import com.elitescloud.boot.common.param.AbstractOrderQueryParam;
import com.elitescloud.cloudt.common.base.PagingVO;

import java.io.Serializable;

/**
 * 数据导出接口.
 *
 * @author Kaiser（wang shao）
 * @date 2021/08/15
 */
public interface DataExport<T extends Serializable, E extends AbstractOrderQueryParam> {

    /**
     * 获取模板编号
     *
     * @return 模板编号
     */
    String getTmplCode();

    /**
     * 导出数据
     *
     * @param queryParam 查询参数
     * @param page       页数，从1开始
     * @param pageSize   页大小，取值范围1~1000
     * @return 数据
     * @deprecated 已过期，请使用 {@link #executeExport(AbstractOrderQueryParam)}
     */
    @Deprecated(forRemoval = true, since = "3.3.0")
    default PagingVO<T> execute(E queryParam, int page, int pageSize) {
        return PagingVO.empty();
    }

    /**
     * 导出数据
     *
     * @param queryParam 查询参数
     * @return 数据
     */
    default PagingVO<T> executeExport(E queryParam) {
        return this.execute(queryParam, queryParam.getCurrent() + 1, queryParam.getSize());
    }

    /**
     * 导出文件的名称
     *
     * @return 导出文件的名称
     */
    default String exportFileName() {
        return null;
    }

    /**
     * 分页查询时每次查询数量
     *
     * @return 页大小
     */
    default Integer pageSize() {
        return 20;
    }

    /**
     * 是否必须有配置模板
     *
     * @return 默认可以不需要配置模板
     */
    default Boolean requireTmpl() {
        return false;
    }
}
