/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.excel.common.spi.impl;

import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.boot.SpringContextHolder;
import com.elitescloud.boot.common.annotation.BusinessObject;
import com.elitescloud.boot.common.annotation.BusinessObjectOperation;
import com.elitescloud.boot.common.param.AbstractOrderQueryParam;
import com.elitescloud.boot.excel.common.DataExport;
import com.elitescloud.boot.excel.config.tmpl.DataExportServiceFactory;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.swagger.openapi.common.spi.OpenApiLoadStrategySPI;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.aop.framework.AopProxyUtils;
import org.springframework.web.bind.annotation.RequestMethod;

public class OpenApiLoadDataExport
implements OpenApiLoadStrategySPI {
    private boolean initialized = false;
    private final List<Class<?>> exportServiceClasses = new ArrayList(32);
    private final Map<Class<?>, DataExportServiceFactory.ServiceMetaData> exportServiceMap = new HashMap();
    private final Map<Class<?>, OpenApiLoadStrategySPI.OpenApiInfo> openApiInfoMap = new HashMap();

    public List<Class<?>> load() {
        if (!this.initialized) {
            this.init();
        }
        return this.exportServiceClasses;
    }

    public List<OpenApiLoadStrategySPI.OpenApiInfo> analyze(Class<?> clazz) {
        OpenApiLoadStrategySPI.OpenApiInfo openApiInfo = this.openApiInfoMap.get(clazz);
        if (openApiInfo != null) {
            return List.of(openApiInfo);
        }
        if (!DataExport.class.isAssignableFrom(clazz)) {
            return Collections.emptyList();
        }
        DataExportServiceFactory.ServiceMetaData exportService = this.exportServiceMap.get(clazz);
        if (exportService == null) {
            return Collections.emptyList();
        }
        Method method = exportService.getMethod();
        openApiInfo = new OpenApiLoadStrategySPI.OpenApiInfo(method, RequestMethod.POST, "/cloudt/core/import/" + exportService.getDataExport().getTmplCode() + "/export");
        BusinessObject businessObject = exportService.getDataExportClass().getAnnotation(BusinessObject.class);
        openApiInfo.setBusinessObject(businessObject);
        BusinessObjectOperation businessOperation = method.getAnnotation(BusinessObjectOperation.class);
        if (businessOperation != null) {
            openApiInfo.setBusinessObjectType(businessOperation.businessObjectType());
            if (businessObject == null && ("@BusinessObject".equals(businessOperation.businessObjectType()) || CharSequenceUtil.isBlank((CharSequence)businessOperation.businessObjectType()))) {
                throw new BusinessException(exportService.getDataExport().getTmplCode() + "\u5bf9\u5e94\u7684\u5bfc\u51fa\u670d\u52a1\u4e2d\u672a\u6307\u5b9a\u6240\u5c5e\u4e1a\u52a1\u5bf9\u8c61");
            }
            openApiInfo.setBusinessObjectOperation(businessOperation);
            openApiInfo.setBusinessOperationCode(businessOperation.operationCode());
            openApiInfo.setOperationDescription(businessOperation.operationDescription());
            openApiInfo.setDetail(businessOperation.detail());
            openApiInfo.setOperationType(businessOperation.operationType());
            openApiInfo.setDataPermissionEnabled(businessOperation.dataPermissionEnabled());
            openApiInfo.setPermissionFields(businessOperation.permissionFields());
        }
        this.openApiInfoMap.put(clazz, openApiInfo);
        return List.of(openApiInfo);
    }

    public boolean isRequestBody(Parameter parameter) {
        return parameter != null && AbstractOrderQueryParam.class.isAssignableFrom(parameter.getType());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        OpenApiLoadDataExport openApiLoadDataExport = this;
        synchronized (openApiLoadDataExport) {
            if (this.initialized) {
                return;
            }
            if (SpringContextHolder.initialized()) {
                this.initializeBySpring();
                this.initialized = true;
            }
        }
    }

    private void initializeBySpring() {
        DataExportServiceFactory factory = (DataExportServiceFactory)SpringContextHolder.getObjectProvider(DataExportServiceFactory.class).getIfAvailable();
        if (factory == null) {
            return;
        }
        Map<String, DataExportServiceFactory.ServiceMetaData> exportService = factory.getAllExportService();
        if (exportService.isEmpty()) {
            return;
        }
        Class clazz = null;
        for (DataExportServiceFactory.ServiceMetaData value : exportService.values()) {
            clazz = AopProxyUtils.ultimateTargetClass((Object)value.getDataExport());
            this.exportServiceMap.put(clazz, value);
            this.exportServiceClasses.add(clazz);
        }
    }
}

