/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.excel.config.tmpl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.exceptions.ExceptionUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ObjUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.poi.excel.RowUtil;
import cn.hutool.poi.excel.cell.CellUtil;
import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.metadata.CellData;
import com.alibaba.excel.metadata.Head;
import com.alibaba.excel.write.builder.ExcelWriterBuilder;
import com.alibaba.excel.write.builder.ExcelWriterSheetBuilder;
import com.alibaba.excel.write.handler.AbstractCellWriteHandler;
import com.alibaba.excel.write.handler.WriteHandler;
import com.alibaba.excel.write.metadata.holder.WriteSheetHolder;
import com.alibaba.excel.write.metadata.holder.WriteTableHolder;
import com.el.coordinator.boot.fsm.model.vo.FileObjRespVO;
import com.el.coordinator.boot.fsm.service.FileService;
import com.elitescloud.boot.common.annotation.BusinessObject;
import com.elitescloud.boot.common.annotation.BusinessObjectOperation;
import com.elitescloud.boot.common.constant.MimeTypeConstant;
import com.elitescloud.boot.common.param.AbstractOrderQueryParam;
import com.elitescloud.boot.common.param.FileByteVO;
import com.elitescloud.boot.excel.common.param.ImportRecordDTO;
import com.elitescloud.boot.excel.common.param.ImportRecordRespVO;
import com.elitescloud.boot.excel.common.support.ExportedDataFormatter;
import com.elitescloud.boot.excel.config.ExcelProperties;
import com.elitescloud.boot.excel.config.tmpl.DataExportServiceFactory;
import com.elitescloud.boot.excel.config.tmpl.DataImportServiceFactory;
import com.elitescloud.boot.excel.config.tmpl.export.CostTime;
import com.elitescloud.boot.excel.config.tmpl.export.ExportCostTime;
import com.elitescloud.boot.excel.config.tmpl.export.ExportStrategyParam;
import com.elitescloud.boot.excel.config.tmpl.export.SystemTmplDataSupport;
import com.elitescloud.boot.excel.config.tmpl.export.strategy.TmplExportStrategyDelegate;
import com.elitescloud.boot.excel.support.TmplDataExportWrapper;
import com.elitescloud.boot.excel.util.ExcelImportUtil;
import com.elitescloud.boot.excel.util.ExcelUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.util.ArrayUtil;
import com.elitescloud.boot.util.DatetimeUtil;
import com.elitescloud.boot.util.ExceptionsUtil;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.context.util.CollectionUtil;
import com.elitescloud.cloudt.context.util.HttpServletUtil;
import com.elitescloud.cloudt.system.dto.SysImportRateDTO;
import com.elitescloud.cloudt.system.dto.SysTmplDTO;
import com.elitescloud.cloudt.system.dto.req.RecordResultSaveDTO;
import com.elitescloud.cloudt.system.dto.resp.ExportResultRespVO;
import com.elitescloud.cloudt.system.dto.resp.ImportRateRespVO;
import com.elitescloud.cloudt.system.dto.resp.ImportResultRespVO;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletRequest;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.core.task.TaskExecutor;
import org.springframework.http.ContentDisposition;
import org.springframework.http.HttpEntity;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.Assert;
import org.springframework.util.StreamUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.mvc.method.annotation.StreamingResponseBody;

class TmplDataService
implements ApplicationRunner {
    private static final Logger log = LogManager.getLogger(TmplDataService.class);
    private final TaskExecutor taskExecutor;
    private final ObjectMapper objectMapper;
    private final DataImportServiceFactory dataImportServiceFactory;
    private final DataExportServiceFactory dataExportServiceFactory;
    private final TmplExportStrategyDelegate exportStrategyDelegate;
    private final ExcelProperties excelProperties;
    private final FileService<?> fileService;
    private final SystemTmplDataSupport fsmTmplSupport;
    private final List<ExportedDataFormatter> exportedDataFormatters;
    private File tempDir = null;

    public TmplDataService(ExcelProperties excelProperties, FileService<?> fileService, SystemTmplDataSupport fsmTmplSupport, DataImportServiceFactory dataImportServiceFactory, DataExportServiceFactory dataExportServiceFactory, TmplExportStrategyDelegate exportStrategyDelegate, TaskExecutor taskExecutor, ObjectMapper objectMapper, List<ExportedDataFormatter> exportedDataFormatters) {
        this.excelProperties = excelProperties;
        this.fileService = fileService;
        this.fsmTmplSupport = fsmTmplSupport;
        this.dataImportServiceFactory = dataImportServiceFactory;
        this.dataExportServiceFactory = dataExportServiceFactory;
        this.exportStrategyDelegate = exportStrategyDelegate;
        this.taskExecutor = taskExecutor;
        this.objectMapper = objectMapper;
        this.exportedDataFormatters = exportedDataFormatters;
        this.initTempDir();
    }

    public void run(ApplicationArguments args) throws Exception {
        CompletableFuture.runAsync(() -> this.fsmTmplSupport.updateResultForSysError("\u670d\u52a1\u505c\u6b62"), (Executor)this.taskExecutor).exceptionally(throwable -> {
            log.warn("\u5904\u7406\u672a\u5bfc\u5165\u7ed3\u675f\u7684\u5931\u8d25\uff1a{}", (Object)ExceptionsUtil.getCauseMsg((Throwable)throwable, (String[])new String[0]));
            return null;
        });
    }

    private void initTempDir() {
        this.tempDir = new File(System.getProperty("java.io.tmpdir"));
        if (this.tempDir.exists()) {
            return;
        }
        if (!this.tempDir.mkdirs()) {
            throw new IllegalArgumentException("\u521b\u5efa\u4e34\u65f6\u6587\u4ef6\u5939\u5931\u8d25\uff1a" + this.tempDir.getAbsolutePath());
        }
    }

    public HttpEntity<StreamingResponseBody> downloadByCode(@NotBlank String code) {
        ApiResult<FileByteVO> tmplInfoResult = this.fsmTmplSupport.getTmplFileByCode(code);
        if (tmplInfoResult.isFailed() || tmplInfoResult.getData() == null) {
            log.info("\u83b7\u53d6\u6a21\u677f\u4fe1\u606f\u5931\u8d25\uff1a{}", (Object)tmplInfoResult.getMsg());
            return this.emptyFile("\u7cfb\u7edf\u670d\u52a1\u5f02\u5e38");
        }
        if (ArrayUtil.isEmpty((byte[])((FileByteVO)tmplInfoResult.getData()).getBytes())) {
            return this.emptyFile("\u6a21\u677f\u6587\u4ef6\u4e0d\u5b58\u5728\u6216\u672a\u914d\u7f6e");
        }
        FileByteVO tmplInfo = (FileByteVO)tmplInfoResult.getData();
        MediaType contentType = (MediaType)ObjUtil.defaultIfNull((Object)MimeTypeConstant.parseMediaType((String)tmplInfo.getMimeType()), (Object)MediaType.APPLICATION_OCTET_STREAM);
        ContentDisposition contentDisposition = ContentDisposition.builder((String)"attachment").filename(tmplInfo.getOriginalName(), StandardCharsets.UTF_8).build();
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().contentType(contentType).header("Content-Disposition", new String[]{contentDisposition.toString()})).contentLength(tmplInfo.getFileSize().longValue()).body(outputStream -> {
            try {
                StreamUtils.copy((byte[])tmplInfo.getBytes(), (OutputStream)outputStream);
            }
            catch (Exception e) {
                log.error("\u4e0b\u8f7d\u6a21\u677f\u6587\u4ef6\u5f02\u5e38\uff1a", (Throwable)e);
            }
        });
    }

    public ApiResult<ImportResultRespVO> importData(@NotBlank String code, @NotNull MultipartFile dataFile) {
        PreparationResult prepareResult = this.prepareForDeal(code, null, dataFile);
        SysTmplDTO tmplDTO = prepareResult.getTmplWrapper().getTmplDTO();
        Long recordId = prepareResult.getRecordId();
        DataImportServiceFactory.ServiceMetaData dataImportService = this.dataImportServiceFactory.getDataImportService(code);
        ImportResultRespVO respVO = null;
        try {
            respVO = this.startImport(recordId, tmplDTO, dataFile, dataImportService);
        }
        catch (Exception exception) {
            log.error("\u5bfc\u5165\u5931\u8d25", (Throwable)exception);
            this.afterImport(tmplDTO, recordId, 0L, ExceptionsUtil.getCauseMsg((Throwable)exception, (String[])new String[0]), null, null);
            return ApiResult.fail((String)ExceptionsUtil.normalize((Throwable)exception, (String)"\u5bfc\u5165\u5931\u8d25").getMessage());
        }
        if (Boolean.TRUE.equals(respVO.getSync())) {
            this.afterImport(tmplDTO, recordId, (long)((Integer)ObjectUtil.defaultIfNull((Object)respVO.getSyncResult().getNumSuccess(), (Object)0)), null, respVO.getSyncResult().getFailMsgCustom(), null);
        }
        return ApiResult.ok((Object)respVO);
    }

    public ApiResult<ExportResultRespVO> exportData(@NotBlank String code, Map<String, Object> queryParam) {
        AnalyseResult result;
        ExportCostTime costTime = ExportCostTime.getInstance();
        costTime.getPrepare().start();
        PreparationResult prepareResult = this.prepareForDeal(code, queryParam, null);
        SysTmplDTO tmplDTO = prepareResult.getTmplWrapper().getTmplDTO();
        Long recordId = prepareResult.getRecordId();
        DataExportServiceFactory.ServiceMetaData dataExportService = this.dataExportServiceFactory.getDataExportService(code);
        if (tmplDTO.getId() == null || -1L == tmplDTO.getId()) {
            if (dataExportService.applyIsRequiredTmpl()) {
                return ApiResult.fail((String)"\u6a21\u677f\u4e0d\u5b58\u5728\u6216\u5df2\u7981\u7528");
            }
            log.info("\u4f7f\u7528\u9ed8\u8ba4\u5bfc\u51fa\u6a21\u677f\uff1a{}", (Object)code);
        }
        this.setBusinessObject(dataExportService);
        try {
            result = this.startExport(recordId, prepareResult.getTmplWrapper(), queryParam, dataExportService, costTime);
        }
        catch (Exception exception) {
            log.error("\u5bfc\u51fa\u5931\u8d25", (Throwable)exception);
            this.afterImport(tmplDTO, recordId, 0L, ExceptionUtil.getRootCause((Throwable)exception).getMessage(), null, costTime);
            return ApiResult.fail((String)("\u5bfc\u51fa\u5931\u8d25" + (String)(exception instanceof BusinessException ? "\uff0c" + exception.getMessage() : "")));
        }
        return ApiResult.ok((Object)new ExportResultRespVO(result.getSync(), recordId, result.getTotal()));
    }

    public HttpEntity<StreamingResponseBody> downloadExportFile(Long id) {
        AtomicInteger times = new AtomicInteger(1);
        String code = TmplDataService.retry(() -> this.fsmTmplSupport.getRecordFileCode(id), c -> {
            if (CharSequenceUtil.isNotBlank((CharSequence)c)) {
                return true;
            }
            return times.getAndAdd(1) >= 5;
        }, Duration.ofMinutes(1L));
        if (CharSequenceUtil.isBlank((CharSequence)code)) {
            log.error("\u4e0b\u8f7d\u5bfc\u51fa\u8bb0\u5f55{}\u7684\u6587\u4ef6\u5931\u8d25\uff0c\u6587\u4ef6\u4e0d\u5b58\u5728", (Object)id);
            byte[] notFound = "\u5bfc\u51fa\u5931\u8d25".getBytes(StandardCharsets.UTF_8);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().contentType(MediaType.APPLICATION_OCTET_STREAM).header("Content-Disposition", new String[]{ContentDisposition.builder((String)"attachment").filename("\u5bfc\u51fa\u5931\u8d25.xlsx", StandardCharsets.UTF_8).build().toString()})).contentLength((long)notFound.length).body(outputStream -> {
                try {
                    StreamUtils.copy((byte[])notFound, (OutputStream)outputStream);
                }
                catch (Exception e) {
                    log.error("\u4e0b\u8f7d\u8d44\u6e90\u6587\u4ef6\u5f02\u5e38\uff1a", (Throwable)e);
                }
            });
        }
        return this.fileService.download(code, null);
    }

    public ApiResult<ImportRateRespVO> getRate(Long id) {
        SysImportRateDTO rateDTO = null;
        try {
            rateDTO = this.fsmTmplSupport.getImportRateFromCache(id);
            if (rateDTO == null) {
                rateDTO = this.fsmTmplSupport.getImportRate(id);
            }
        }
        catch (Exception exception) {
            log.error("\u67e5\u8be2\u8fdb\u5ea6\u5931\u8d25", (Throwable)exception);
            return ApiResult.fail((String)"\u67e5\u8be2\u8fdb\u5ea6\u5931\u8d25");
        }
        if (rateDTO == null) {
            return ApiResult.fail((String)"\u8bb0\u5f55\u4e0d\u5b58\u5728");
        }
        ImportRateRespVO respVO = new ImportRateRespVO();
        respVO.setFinish(rateDTO.getFinish());
        respVO.setTotal(rateDTO.getTotal());
        if (Boolean.TRUE.equals(rateDTO.getFinish()) || ObjectUtil.equals((Object)rateDTO.getTotal(), (Object)rateDTO.getCount())) {
            respVO.setCount(rateDTO.getTotal());
            respVO.setFinish(true);
            respVO.setRate("100%");
        } else {
            long count = ((Number)ObjectUtil.defaultIfNull((Object)rateDTO.getCount(), (Object)0)).longValue();
            long total = ((Number)ObjectUtil.defaultIfNull((Object)rateDTO.getTotal(), (Object)1)).longValue();
            respVO.setCount(rateDTO.getCount());
            respVO.setRate(BigDecimal.valueOf((double)count * 1.0 / (double)total * 100.0).setScale(0, RoundingMode.DOWN) + "%");
        }
        respVO.setNumSuccess(rateDTO.getNumSuccess());
        respVO.setFailFileCode(rateDTO.getFailFileCode());
        respVO.setFailMsgCustom(rateDTO.getFailMsgCustom());
        return ApiResult.ok((Object)respVO);
    }

    public ApiResult<List<ImportRecordRespVO>> queryRecord(@NotBlank String tmplCode, Integer hours, Boolean self) {
        List<ImportRecordDTO> recordDtoList = this.fsmTmplSupport.queryRecord(tmplCode, hours, self);
        if (CollUtil.isEmpty(recordDtoList)) {
            return ApiResult.ok(Collections.emptyList());
        }
        List fileCodes = recordDtoList.stream().flatMap(t -> Stream.of(t.getFileCode(), t.getFailFileCode())).filter(StringUtils::hasText).collect(Collectors.toList());
        Map<Object, Object> fileInfoMap = null;
        if (CollUtil.isNotEmpty(fileCodes)) {
            com.el.coordinator.core.common.api.ApiResult fileInfoResult = this.fileService.query(fileCodes);
            if (!fileInfoResult.isSuccess()) {
                log.error("\u67e5\u8be2\u6587\u4ef6\u5f02\u5e38\uff1a{}", (Object)fileInfoResult.getMsg());
            }
            if (CollUtil.isNotEmpty((Collection)((Collection)fileInfoResult.getData()))) {
                fileInfoMap = ((List)fileInfoResult.getData()).stream().collect(Collectors.toMap(FileObjRespVO::getFileCode, t -> t, (t1, t2) -> t1));
            }
        }
        Map finalFileInfoMap = fileInfoMap = fileInfoMap == null ? Collections.emptyMap() : fileInfoMap;
        List respVoList = recordDtoList.stream().map(t -> {
            ImportRecordRespVO respVO = new ImportRecordRespVO();
            respVO.setId(t.getId());
            respVO.setUserName(t.getUserName());
            respVO.setFileInfo(t.getFileCode() == null ? null : (FileObjRespVO)finalFileInfoMap.get(t.getFileCode()));
            respVO.setTimeImport(t.getTimeImport());
            respVO.setTimeFinish(t.getTimeFinish());
            respVO.setFinish(t.getFinish());
            respVO.setNumTotal(t.getNumTotal());
            respVO.setNumSuc(t.getNumSuc());
            respVO.setFailFileInfo(t.getFailFileCode() == null ? null : (FileObjRespVO)finalFileInfoMap.get(t.getFailFileCode()));
            respVO.setFailReason(t.getFailReason());
            respVO.setFailMsgCustom(t.getFailMsgCustom());
            return respVO;
        }).collect(Collectors.toList());
        return ApiResult.ok(respVoList);
    }

    private void setBusinessObject(DataExportServiceFactory.ServiceMetaData dataExportService) {
        HttpServletRequest request = HttpServletUtil.currentRequest();
        Assert.notNull((Object)request, (String)"Request\u4e3a\u7a7a");
        BusinessObject businessObject = dataExportService.getDataExportClass().getAnnotation(BusinessObject.class);
        BusinessObjectOperation businessObjectOperation = dataExportService.getMethod().getAnnotation(BusinessObjectOperation.class);
        if (businessObjectOperation != null) {
            request.setAttribute("cloudt-businessObject-operation", (Object)businessObjectOperation);
        }
        if (businessObject == null) {
            request.setAttribute("cloudt-businessObject", (Object)businessObject);
        }
    }

    private HttpEntity<StreamingResponseBody> emptyFile(String prompt) {
        byte[] contents = prompt.getBytes(StandardCharsets.UTF_8);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().contentType(MediaType.APPLICATION_OCTET_STREAM).header("Content-Disposition", new String[]{ContentDisposition.builder((String)"attachment").filename(prompt + ".xlsx", StandardCharsets.UTF_8).build().toString()})).contentLength((long)contents.length).body(outputStream -> {
            try {
                StreamUtils.copy((byte[])contents, (OutputStream)outputStream);
            }
            catch (Exception e) {
                log.error("\u4e0b\u8f7d\u6a21\u677f\u6587\u4ef6\u5f02\u5e38\uff1a", (Throwable)e);
            }
        });
    }

    private SysTmplDTO createDefaultExportTmplDTO(String tmplCode) {
        SysTmplDTO tmplDTO = new SysTmplDTO();
        tmplDTO.setName("\u9ed8\u8ba4\u6a21\u677f");
        tmplDTO.setCode(tmplCode);
        tmplDTO.setFileCode(null);
        tmplDTO.setExport(true);
        tmplDTO.setHeadRow(2);
        tmplDTO.setFieldTypeRow(2);
        tmplDTO.setEnabled(true);
        tmplDTO.setDataLimitPer(-1);
        tmplDTO.setAsyncThreshold(20);
        tmplDTO.setConcurrentLimit(50);
        tmplDTO.setAttributes(null);
        tmplDTO.setAttributeTitles(null);
        tmplDTO.setAttributeFields(null);
        tmplDTO.setExportSheetLimit(1000000);
        tmplDTO.setExportSheetStrategy("NEW_SHEET");
        return tmplDTO;
    }

    private PreparationResult prepareForDeal(@NotBlank String code, Map<String, Object> queryParam, MultipartFile importFile) {
        SysTmplDTO tmplDTO = this.fsmTmplSupport.getTmplByCode(code);
        if (tmplDTO == null && importFile == null) {
            tmplDTO = this.createDefaultExportTmplDTO(code);
        }
        TmplDataExportWrapper tmplWrapper = new TmplDataExportWrapper(tmplDTO, queryParam, this.fsmTmplSupport);
        String msg = this.validateBeforeDeal(tmplDTO, queryParam, importFile);
        Assert.isTrue((boolean)CharSequenceUtil.isBlank((CharSequence)msg), (String)msg);
        Long recordId = null;
        try {
            recordId = this.saveRecord(code, importFile, queryParam);
        }
        catch (Exception exception) {
            boolean isExport = Boolean.TRUE.equals(tmplDTO.getExport());
            throw ExceptionsUtil.normalize((Throwable)exception, (String)(isExport ? "\u5bfc\u51fa\u6570\u636e\u5f02\u5e38" : "\u5bfc\u5165\u6570\u636e\u5f02\u5e38"));
        }
        return new PreparationResult(tmplWrapper, recordId);
    }

    private String validateBeforeDeal(SysTmplDTO tmplDTO, Map<String, Object> queryParam, MultipartFile importFile) {
        if (tmplDTO == null) {
            return null;
        }
        if (Boolean.FALSE.equals(tmplDTO.getEnabled())) {
            return "\u6a21\u677f\u6216\u5df2\u7981\u7528";
        }
        if (CollUtil.isEmpty(tmplDTO.getAttributeFields())) {
            return "\u6a21\u677f\u65e0\u6548\uff0c\u672a\u53d1\u73b0\u6570\u636e\u5b57\u6bb5\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u91cd\u65b0\u914d\u7f6e";
        }
        boolean export = Boolean.TRUE.equals(tmplDTO.getExport());
        if (export) {
            if (!this.dataExportServiceFactory.isSupport(tmplDTO.getCode())) {
                return "\u672a\u53d1\u73b0\u6709\u6548\u7684\u6570\u636e\u5bfc\u51fa\u670d\u52a1\uff0c\u8bf7\u786e\u8ba4\u6a21\u677f\u7f16\u7801\u662f\u5426\u6b63\u786e";
            }
        } else {
            Assert.notNull((Object)importFile, (String)("\u6839\u636e\u5bfc\u5165\u6a21\u677f" + tmplDTO.getCode() + "\u5bfc\u5165\u6570\u636e\u65f6\u672a\u53d1\u73b0\u6709\u6548\u5bfc\u5165\u6587\u4ef6"));
            if (!this.dataImportServiceFactory.isSupport(tmplDTO.getCode())) {
                return "\u672a\u53d1\u73b0\u6709\u6548\u7684\u6570\u636e\u5bfc\u5165\u670d\u52a1\uff0c\u8bf7\u786e\u8ba4\u6a21\u677f\u7f16\u7801\u662f\u5426\u6b63\u786e";
            }
        }
        if (!this.fsmTmplSupport.updateLimiter(tmplDTO, true)) {
            return "\u5f53\u524d\u8bbf\u95ee\u7528\u6237\u8fc7\u591a\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5";
        }
        return null;
    }

    private Long saveRecord(String tmplCode, MultipartFile dataFile, Map<String, Object> queryParam) {
        return this.fsmTmplSupport.saveRecord(tmplCode, dataFile, queryParam);
    }

    private void afterImport(SysTmplDTO tmplDTO, Long recordId, Long numSuc, String failMsg, String customTipMsg, CostTime costTime) {
        this.afterImport(tmplDTO, recordId, numSuc, failMsg, customTipMsg, null, costTime);
    }

    private void afterImport(SysTmplDTO tmplDTO, Long recordId, Long numSuc, String failMsg, String customTipMsg, File file, CostTime costTime) {
        if (recordId != null) {
            String fileCode = this.uploadImportFile(file);
            RecordResultSaveDTO importResultDTO = RecordResultSaveDTO.builder().recordId(recordId).success(CharSequenceUtil.isBlank((CharSequence)failMsg)).numSuc(numSuc).failMsg(failMsg).customTipMsg(customTipMsg).fileCode(fileCode).costTimeInfo(costTime == null ? null : costTime.shortSummary()).build();
            log.info("\u5bfc\u5165\u5bfc\u51fa\u7ed3\u675f\uff1a{}\uff0c{}\uff0c{}", (Object)recordId, (Object)importResultDTO.getSuccess(), (Object)importResultDTO.getCostTimeInfo());
            this.fsmTmplSupport.updateImportResult(importResultDTO);
        } else {
            log.error("\u66f4\u65b0\u5bfc\u5165\u5bfc\u51fa\u8bb0\u5f55\u7ed3\u679c\u5931\u8d25\uff1a{}", (Object)failMsg);
        }
        this.fsmTmplSupport.updateLimiter(tmplDTO, false);
    }

    private String uploadImportFile(File file) {
        if (file == null) {
            return null;
        }
        com.el.coordinator.core.common.api.ApiResult uploadResult = this.fileService.upload(file);
        file.delete();
        if (uploadResult.isSuccess() && uploadResult.getData() != null) {
            return ((FileObjRespVO)uploadResult.getData()).getFileCode();
        }
        log.error("\u4e0a\u4f20\u5bfc\u5165\u5bfc\u51fa\u7ed3\u679c\u6587\u4ef6\u5931\u8d25\uff1a{}", (Object)uploadResult);
        return null;
    }

    private List<? extends Serializable> analyseData(SysTmplDTO tmplDTO, MultipartFile dataFile, DataImportServiceFactory.ServiceMetaData dataImportService) {
        Set<Integer> sheetNos = dataImportService.applyGetSheetNos();
        if (CollUtil.isEmpty(sheetNos) && CollUtil.isNotEmpty(tmplDTO.getSheetNoList())) {
            sheetNos = new HashSet<Integer>(tmplDTO.getSheetNoList());
        }
        try {
            return ExcelImportUtil.instance(dataFile.getInputStream()).headRow(tmplDTO.getHeadRow()).dataType(dataImportService.applyGetDataType(), tmplDTO.getAttributeFields()).sheetNo(sheetNos).readAllSync();
        }
        catch (Exception e) {
            throw new BusinessException("\u89e3\u6790\u5bfc\u5165\u6570\u636e\u5931\u8d25", (Throwable)e);
        }
    }

    private AnalyseResult startExport(Long recordId, TmplDataExportWrapper tmplWrapper, Map<String, Object> queryParam, DataExportServiceFactory.ServiceMetaData dataExportService, ExportCostTime costTime) {
        boolean sync;
        Object param = this.convertParam(queryParam, dataExportService.applyGetParamType());
        int pageSize = dataExportService.applyGetPageSize();
        param.setCurrent(Integer.valueOf(1));
        param.setSize(Integer.valueOf(pageSize));
        costTime.getPrepare().stop();
        costTime.getQueryData().start();
        PagingVO queryResult = this.queryExportData(dataExportService, param);
        costTime.getQueryData().stop();
        if (queryResult == null || queryResult.getTotal() == 0L) {
            throw new BusinessException("\u6ca1\u6709\u7b26\u5408\u6761\u4ef6\u7684\u6570\u636e");
        }
        SysTmplDTO tmplDTO = tmplWrapper.getTmplDTO();
        int limit = (Integer)ObjectUtil.defaultIfNull((Object)tmplDTO.getDataLimitPer(), (Object)-1);
        if (limit != -1 && queryResult.getTotal() > (long)limit) {
            throw new BusinessException("\u6bcf\u6b21\u6700\u591a\u5141\u8bb8\u5bfc\u51fa" + limit + "\u6761");
        }
        CompletableFuture.runAsync(() -> this.fsmTmplSupport.updateImportNum(recordId, queryResult.getTotal()), (Executor)this.taskExecutor);
        boolean bl = sync = tmplDTO.getAsyncThreshold() == null || tmplDTO.getAsyncThreshold() == -1 || queryResult.getTotal() <= (long)tmplDTO.getAsyncThreshold().intValue();
        if (sync) {
            this.exportSync(recordId, tmplWrapper, queryResult, param, dataExportService, costTime);
            return new AnalyseResult(queryResult.getTotal(), true);
        }
        this.exportAsync(recordId, tmplWrapper, queryResult, param, dataExportService, costTime);
        return new AnalyseResult(queryResult.getTotal(), false);
    }

    private <R extends Serializable, P extends AbstractOrderQueryParam> void exportAsync(Long recordId, TmplDataExportWrapper tmplWrapper, PagingVO<R> pageData, P queryParam, DataExportServiceFactory.ServiceMetaData dataExportService, ExportCostTime costTime) {
        CompletableFuture.supplyAsync(() -> this.write2Excel(false, recordId, tmplWrapper, pageData, queryParam, dataExportService, costTime), (Executor)this.taskExecutor).whenComplete((ret, throwable) -> {
            this.fsmTmplSupport.removeRate(recordId);
            if (throwable == null) {
                this.afterImport(tmplWrapper.getTmplDTO(), recordId, (Long)ret, null, null, costTime);
                return;
            }
            this.afterImport(tmplWrapper.getTmplDTO(), recordId, 0L, ExceptionUtil.getRootCause((Throwable)throwable).getMessage(), null, costTime);
            log.error("\u5bfc\u51fa\u6570\u636e\u65f6\u51fa\u73b0\u5f02\u5e38\uff1a", throwable);
        });
    }

    private <R extends Serializable, P extends AbstractOrderQueryParam> void exportSync(Long recordId, TmplDataExportWrapper tmplWrapper, PagingVO<R> pageData, P queryParam, DataExportServiceFactory.ServiceMetaData dataExportService, ExportCostTime costTime) {
        Long num = null;
        String msg = null;
        try {
            num = this.write2Excel(true, recordId, tmplWrapper, pageData, queryParam, dataExportService, costTime);
        }
        catch (Exception e) {
            log.error("\u540c\u6b65\u5bfc\u51fa\u5f02\u5e38\uff1a", (Throwable)e);
            msg = e.getMessage();
        }
        this.afterImport(tmplWrapper.getTmplDTO(), recordId, num, msg, null, costTime);
    }

    private <R extends Serializable, P extends AbstractOrderQueryParam> Long write2Excel(boolean sync, Long recordId, TmplDataExportWrapper tmplWrapper, PagingVO<R> pageData, P queryParam, DataExportServiceFactory.ServiceMetaData dataExportService, ExportCostTime costTime) {
        costTime.getPrepare().start();
        ExportStrategyParam param = new ExportStrategyParam().setSync(sync).setImportId(recordId).setTmplExportWrapper(tmplWrapper).setFirstPageData(pageData).setQueryParam(queryParam).setDataProvider(p -> this.queryExportData(dataExportService, p)).setExportFileName(CharSequenceUtil.blankToDefault((CharSequence)dataExportService.applyGetExportFileName(), (String)tmplWrapper.getTmplDTO().getName())).setPageSize(queryParam.getSize()).setCostTime(costTime);
        try {
            return this.exportStrategyDelegate.export(param);
        }
        catch (Exception e) {
            throw new BusinessException("\u5bfc\u51fa\u6570\u636e\u5f02\u5e38", (Throwable)e);
        }
    }

    private <P extends AbstractOrderQueryParam, R extends Serializable> PagingVO<R> queryExportData(DataExportServiceFactory.ServiceMetaData dataExportService, P queryParam) {
        PagingVO pageData = dataExportService.applyExport(queryParam, Boolean.TRUE.equals(this.excelProperties.getUseReflect()));
        if (pageData.isEmpty() || this.exportedDataFormatters.isEmpty()) {
            return pageData;
        }
        for (ExportedDataFormatter exportedDataFormatter : this.exportedDataFormatters) {
            try {
                exportedDataFormatter.format(dataExportService, pageData.getRecords());
            }
            catch (BusinessException e) {
                log.error("\u683c\u5f0f\u5316\u5bfc\u51fa\u6570\u636e\u5f02\u5e38\uff1a", (Throwable)e);
            }
        }
        return pageData;
    }

    private <P extends AbstractOrderQueryParam> P convertParam(Map<String, Object> queryParam, Class<P> paramType) {
        try {
            return (P)((AbstractOrderQueryParam)this.objectMapper.convertValue(queryParam, paramType));
        }
        catch (IllegalArgumentException e) {
            throw new BusinessException("\u8f6c\u6362\u67e5\u8be2\u53c2\u6570\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u53c2\u6570\u683c\u5f0f", (Throwable)e);
        }
    }

    private ImportResultRespVO startImport(Long recordId, SysTmplDTO tmplDTO, MultipartFile dataFile, DataImportServiceFactory.ServiceMetaData dataImportService) {
        boolean sync;
        List<? extends Serializable> dataList = this.analyseData(tmplDTO, dataFile, dataImportService);
        int total = dataList.size();
        if (total == 0) {
            throw new BusinessException("\u5bfc\u5165\u6570\u636e\u4e3a\u7a7a");
        }
        if (tmplDTO.getDataLimitPer() != -1 && total > tmplDTO.getDataLimitPer()) {
            throw new BusinessException("\u6bcf\u6b21\u6700\u591a\u5141\u8bb8\u5bfc\u5165" + tmplDTO.getDataLimitPer() + "\u6761");
        }
        dataImportService.applyBeforeImport(dataList);
        this.fsmTmplSupport.updateImportNum(recordId, Long.valueOf(total));
        File tempDataFile = FileUtil.createTempFile();
        String dataFileName = dataFile.getOriginalFilename();
        try {
            dataFile.transferTo(tempDataFile);
        }
        catch (IOException e) {
            throw new IllegalStateException("\u521b\u5efa\u4e34\u65f6\u6587\u4ef6\u5f02\u5e38", e);
        }
        boolean bl = sync = tmplDTO.getAsyncThreshold() == null || tmplDTO.getAsyncThreshold() == -1 || total <= tmplDTO.getAsyncThreshold();
        if (sync) {
            ImportResultRespVO.SyncResult syncResult = this.executeImport(dataImportService, dataList, tmplDTO.getHeadRow() + 1);
            String failFileCode = this.saveFailRecord(recordId, tempDataFile, dataFileName, tmplDTO, dataList, syncResult.getFailRecords());
            syncResult.setFailFileCode(failFileCode);
            if (!dataImportService.isRespFailMsg()) {
                syncResult.setFailRecords(Collections.emptyList());
            }
            String failMsgCustom = dataImportService.applyMsgFail();
            syncResult.setFailMsgCustom(failMsgCustom);
            dataImportService.applyAfterImport(true);
            return ImportResultRespVO.builder().sync(true).syncResult(syncResult).build();
        }
        CompletableFuture.supplyAsync(() -> this.importAsync(tmplDTO, recordId, dataImportService, dataList), (Executor)this.taskExecutor).whenComplete((ret, throwable) -> {
            String failMsgCustom;
            if (ret != null) {
                this.saveFailRecord(recordId, tempDataFile, dataFileName, tmplDTO, dataList, ret.getFailRecords());
            }
            int numSuccess = ret == null ? 0 : ret.getNumSuccess();
            String string = failMsgCustom = ret == null ? null : ret.getFailMsgCustom();
            if (throwable == null) {
                this.afterImport(tmplDTO, recordId, Long.valueOf(numSuccess), null, failMsgCustom, null);
            } else {
                this.afterImport(tmplDTO, recordId, Long.valueOf(numSuccess), ((Throwable)ObjectUtil.defaultIfNull((Object)ExceptionUtil.getRootCause((Throwable)throwable), (Object)throwable)).getMessage(), failMsgCustom, null);
                log.error("\u5bfc\u5165\u6570\u636e\u65f6\u51fa\u73b0\u5f02\u5e38\uff1a", throwable);
            }
            this.fsmTmplSupport.removeRate(recordId);
            tempDataFile.delete();
            dataImportService.applyAfterImport(false);
        });
        return ImportResultRespVO.builder().sync(false).asyncResult(ImportResultRespVO.AsyncResult.builder().importId(recordId).build()).build();
    }

    private ImportResultRespVO.SyncResult importAsync(SysTmplDTO tmplDTO, Long recordId, DataImportServiceFactory.ServiceMetaData dataImportService, List<? extends Serializable> dataList) {
        int total = dataList.size();
        int size = dataImportService.applyGetStepSize();
        int start = 0;
        int count = 0;
        int numSuc = 0;
        ImportResultRespVO.SyncResult tempResult = null;
        String failMsgCustom = null;
        ArrayList<String> fail = new ArrayList<String>(1024);
        int i = 0;
        while (true) {
            boolean finish;
            start = i * size;
            count = Math.min(start + size, total);
            List<? extends Serializable> toImportData = dataList.subList(start, count);
            tempResult = this.executeImport(dataImportService, toImportData, tmplDTO.getHeadRow() + 1 + start);
            numSuc += tempResult.getNumSuccess().intValue();
            fail.addAll(tempResult.getFailRecords());
            boolean bl = finish = count >= total;
            if (finish) {
                failMsgCustom = dataImportService.applyMsgFail();
            }
            this.fsmTmplSupport.storeRate(recordId, SysImportRateDTO.builder().total(Long.valueOf(total)).finish(false).count((long)count - 1L).numSuccess(Long.valueOf(numSuc)).tmplCode(dataImportService.applyGetTmplCode()).failMsgCustom(failMsgCustom).build());
            if (finish) break;
            ++i;
        }
        return ImportResultRespVO.SyncResult.builder().total(total).numSuccess(numSuc).failRecords(fail).failMsgCustom(failMsgCustom).build();
    }

    private ImportResultRespVO.SyncResult executeImport(DataImportServiceFactory.ServiceMetaData dataImportService, List<? extends Serializable> dataList, int startIndex) {
        ArrayList<Serializable> dataFail;
        int total = dataList.size();
        List failRecords = null;
        try {
            failRecords = dataImportService.applyImport(dataList, startIndex);
        }
        catch (Throwable e) {
            log.error("\u5bfc\u5165\u5931\u8d25", e);
            failRecords = CollectionUtil.toList((Object)((Throwable)ObjectUtil.defaultIfNull((Object)ExceptionsUtil.getRootCause((Throwable)e), (Object)e)).getMessage(), (int)total);
        }
        if (failRecords == null) {
            failRecords = CollectionUtil.toList(null, (int)total);
        } else if (failRecords.size() != total) {
            log.error(dataImportService.applyGetTmplCode() + "\u8fd4\u56de\u7684\u5bfc\u5165\u7ed3\u679c\u4e0e\u6570\u636e\u91cf\u4e0d\u5339\u914d");
        }
        boolean isRespSuccessData = dataImportService.isRespSuccessData();
        boolean isRespFailData = dataImportService.isRespFailData();
        ArrayList<Serializable> dataSuccess = isRespSuccessData ? new ArrayList<Serializable>(dataList.size()) : new ArrayList(0);
        ArrayList<Serializable> arrayList = dataFail = isRespFailData ? new ArrayList<Serializable>(dataList.size()) : new ArrayList(0);
        if (isRespSuccessData || isRespFailData) {
            log.info("\u8fd4\u56de\u5bfc\u5165\u7ed3\u679c\uff1a{}\uff0c{}", (Object)isRespSuccessData, (Object)isRespFailData);
            int i = 0;
            Serializable data = null;
            for (String failRecord : failRecords) {
                data = dataList.get(i);
                if (failRecord == null && isRespSuccessData) {
                    dataSuccess.add(data);
                }
                if (failRecord != null && isRespFailData) {
                    dataFail.add(data);
                }
                ++i;
            }
        }
        return ImportResultRespVO.SyncResult.builder().total(total).numSuccess((int)failRecords.stream().filter(CharSequenceUtil::isBlank).count()).failRecords(failRecords).dataSuccess(dataSuccess).dataFail(dataFail).build();
    }

    private String saveFailRecord(long importId, File dataFile, String dataFileName, SysTmplDTO tmplDTO, List<?> dataList, List<String> failRecords) {
        boolean success;
        boolean bl = success = failRecords == null || failRecords.isEmpty() || failRecords.stream().noneMatch(StringUtils::hasText);
        if (success) {
            log.info("\u5bfc\u5165\u6210\u529f\uff0c\u65e0\u9700\u8bb0\u5f55\u5931\u8d25\u6587\u4ef6\uff01");
            return null;
        }
        if (dataList.size() != failRecords.size()) {
            log.error(tmplDTO.getCode() + "\u6570\u636e\u6570\u91cf\u4e0e\u5931\u8d25\u8bb0\u5f55\u6570\u91cf\u4e0d\u4e00\u81f4\uff0c\u65e0\u6cd5\u4fdd\u5b58\u5931\u8d25\u8bb0\u5f55");
            return null;
        }
        List<List<String>> failData = null;
        try {
            failData = this.convertFailData(tmplDTO, dataList, failRecords);
        }
        catch (Exception e) {
            log.error("\u8f6c\u6362\u5bfc\u5165\u5931\u8d25\u7684\u6570\u636e\u5f02\u5e38\uff1a", (Throwable)e);
            return null;
        }
        try {
            File failRecordFile = this.writeFailRecordToFile(dataFile, dataFileName, tmplDTO, failData);
            com.el.coordinator.core.common.api.ApiResult fileUploadResult = this.fileService.upload(failRecordFile);
            failRecordFile.delete();
            if (fileUploadResult.getData() == null) {
                log.error("\u4e0a\u4f20\u5931\u8d25\u8bb0\u5f55\u6587\u4ef6\u5931\u8d25\uff1a{}", (Object)fileUploadResult.getMsg());
                return null;
            }
            this.fsmTmplSupport.saveImportFailRecord(importId, ((FileObjRespVO)fileUploadResult.getData()).getFileCode());
            return ((FileObjRespVO)fileUploadResult.getData()).getFileCode();
        }
        catch (Exception e) {
            log.error("\u4fdd\u5b58\u5931\u8d25\u8bb0\u5f55\u5f02\u5e38\uff1a", (Throwable)e);
            return null;
        }
    }

    private File writeFailRecordToFile(File dataFile, String dataFileName, SysTmplDTO tmplDTO, List<List<String>> failRecords) throws Exception {
        Object fileName = CharSequenceUtil.blankToDefault((CharSequence)dataFileName, (String)dataFile.getName());
        int indexDot = ((String)fileName).indexOf(".");
        fileName = indexDot > 0 ? ((String)fileName).substring(0, indexDot) : "";
        fileName = "Error_" + (String)fileName + "_" + DatetimeUtil.FORMATTER_DATETIME_LONG.format(LocalDateTime.now()) + ".xlsx";
        File failFile = new File(this.tempDir, (String)fileName);
        failFile.createNewFile();
        int colSize = failRecords.get(0).size();
        ((ExcelWriterSheetBuilder)((ExcelWriterBuilder)EasyExcel.write((File)failFile).relativeHeadRowIndex(tmplDTO.getHeadRow())).sheet("Sheet1").registerWriteHandler((WriteHandler)new FailDataExcelCellWriteHandler(colSize - 1))).doWrite(failRecords);
        Sheet sheetOriginal = ExcelUtil.getReader((File)dataFile, (int)0).getSheet();
        try (FileInputStream failFileInputStream = new FileInputStream(failFile);){
            Sheet sheetFail = cn.hutool.poi.excel.ExcelUtil.getReader((InputStream)failFileInputStream).getSheet();
            this.writeFailTitle(sheetFail, colSize - 1);
            ExcelUtil.copyRows(sheetOriginal, sheetFail, 0, tmplDTO.getHeadRow() - 1);
            try (FileOutputStream failFileOutStream = new FileOutputStream(failFile);){
                sheetFail.getWorkbook().write((OutputStream)failFileOutStream);
                sheetFail.getWorkbook().close();
            }
        }
        return failFile;
    }

    private void writeFailTitle(Sheet sheet, int msgColIndex) {
        sheet.setColumnWidth(msgColIndex, 5120);
        Row row = RowUtil.getOrCreateRow((Sheet)sheet, (int)0);
        Cell col = CellUtil.getOrCreateCell((Row)row, (int)msgColIndex);
        CellStyle style = sheet.getWorkbook().createCellStyle();
        style.cloneStyleFrom(col.getCellStyle());
        style.setVerticalAlignment(VerticalAlignment.CENTER);
        style.setAlignment(HorizontalAlignment.CENTER);
        Font font = sheet.getWorkbook().createFont();
        font.setColor((short)10);
        font.setBold(true);
        style.setFont(font);
        col.setCellStyle(style);
        col.setCellValue("\u9519\u8bef\u4fe1\u606f");
    }

    private List<List<String>> convertFailData(SysTmplDTO tmplDTO, List<?> dataList, List<String> failRecords) throws Exception {
        ArrayList<List<String>> recordList = new ArrayList<List<String>>(failRecords.size());
        int i = -1;
        Map valueMap = null;
        ArrayList<String> record = null;
        for (String failRecord : failRecords) {
            ++i;
            if (CharSequenceUtil.isBlank((CharSequence)failRecord)) continue;
            valueMap = (Map)this.objectMapper.readValue(this.objectMapper.writeValueAsString(dataList.get(i)), (TypeReference)new TypeReference<Map<String, Object>>(){});
            record = new ArrayList<String>(valueMap.size());
            Object value = null;
            for (String attributeField : tmplDTO.getAttributeFields()) {
                value = ObjectUtil.defaultIfNull(valueMap.get(attributeField), (Object)"");
                if (value instanceof String) {
                    record.add((String)value);
                    continue;
                }
                record.add(this.objectMapper.writeValueAsString(value));
            }
            record.add(failRecord);
            recordList.add(record);
        }
        return recordList;
    }

    private static <T> T retry(Supplier<T> supplier, Predicate<T> predicate, Duration timeout) {
        long limit = timeout.toMillis();
        long start = System.currentTimeMillis();
        int times = 1;
        T result = null;
        while (!predicate.test(result = (T)supplier.get()) && System.currentTimeMillis() - start <= limit) {
            try {
                TimeUnit.SECONDS.sleep(times);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            ++times;
        }
        return result;
    }

    static class PreparationResult {
        private TmplDataExportWrapper tmplWrapper;
        private Long recordId;

        public PreparationResult(TmplDataExportWrapper tmplWrapper, Long recordId) {
            this.tmplWrapper = tmplWrapper;
            this.recordId = recordId;
        }

        public TmplDataExportWrapper getTmplWrapper() {
            return this.tmplWrapper;
        }

        public Long getRecordId() {
            return this.recordId;
        }

        public void setTmplWrapper(TmplDataExportWrapper tmplWrapper) {
            this.tmplWrapper = tmplWrapper;
        }

        public void setRecordId(Long recordId) {
            this.recordId = recordId;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PreparationResult)) {
                return false;
            }
            PreparationResult other = (PreparationResult)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$recordId = this.getRecordId();
            Long other$recordId = other.getRecordId();
            if (this$recordId == null ? other$recordId != null : !((Object)this$recordId).equals(other$recordId)) {
                return false;
            }
            TmplDataExportWrapper this$tmplWrapper = this.getTmplWrapper();
            TmplDataExportWrapper other$tmplWrapper = other.getTmplWrapper();
            return !(this$tmplWrapper == null ? other$tmplWrapper != null : !this$tmplWrapper.equals(other$tmplWrapper));
        }

        protected boolean canEqual(Object other) {
            return other instanceof PreparationResult;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $recordId = this.getRecordId();
            result = result * 59 + ($recordId == null ? 43 : ((Object)$recordId).hashCode());
            TmplDataExportWrapper $tmplWrapper = this.getTmplWrapper();
            result = result * 59 + ($tmplWrapper == null ? 43 : $tmplWrapper.hashCode());
            return result;
        }

        public String toString() {
            return "TmplDataService.PreparationResult(tmplWrapper=" + this.getTmplWrapper() + ", recordId=" + this.getRecordId() + ")";
        }
    }

    static class AnalyseResult {
        private Long total;
        private Boolean sync;

        public AnalyseResult(Long total, Boolean sync) {
            this.total = total;
            this.sync = sync;
        }

        public Long getTotal() {
            return this.total;
        }

        public Boolean getSync() {
            return this.sync;
        }

        public void setTotal(Long total) {
            this.total = total;
        }

        public void setSync(Boolean sync) {
            this.sync = sync;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AnalyseResult)) {
                return false;
            }
            AnalyseResult other = (AnalyseResult)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$total = this.getTotal();
            Long other$total = other.getTotal();
            if (this$total == null ? other$total != null : !((Object)this$total).equals(other$total)) {
                return false;
            }
            Boolean this$sync = this.getSync();
            Boolean other$sync = other.getSync();
            return !(this$sync == null ? other$sync != null : !((Object)this$sync).equals(other$sync));
        }

        protected boolean canEqual(Object other) {
            return other instanceof AnalyseResult;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $total = this.getTotal();
            result = result * 59 + ($total == null ? 43 : ((Object)$total).hashCode());
            Boolean $sync = this.getSync();
            result = result * 59 + ($sync == null ? 43 : ((Object)$sync).hashCode());
            return result;
        }

        public String toString() {
            return "TmplDataService.AnalyseResult(total=" + this.getTotal() + ", sync=" + this.getSync() + ")";
        }
    }

    static class FailDataExcelCellWriteHandler
    extends AbstractCellWriteHandler {
        private final int msgColIndex;

        public FailDataExcelCellWriteHandler(int msgColIndex) {
            this.msgColIndex = msgColIndex;
        }

        public void afterCellDataConverted(WriteSheetHolder writeSheetHolder, WriteTableHolder writeTableHolder, CellData cellData, Cell cell, Head head, Integer relativeRowIndex, Boolean isHead) {
            if (cell.getColumnIndex() == this.msgColIndex) {
                CellStyle style = writeSheetHolder.getSheet().getWorkbook().createCellStyle();
                style.cloneStyleFrom(cell.getCellStyle());
                style.setAlignment(HorizontalAlignment.LEFT);
                style.setVerticalAlignment(VerticalAlignment.CENTER);
                style.setWrapText(true);
                Font font = writeSheetHolder.getSheet().getWorkbook().createFont();
                font.setColor((short)10);
                style.setFont(font);
                cell.setCellStyle(style);
            }
        }

        public void afterCellDispose(WriteSheetHolder writeSheetHolder, WriteTableHolder writeTableHolder, List<CellData> cellDataList, Cell cell, Head head, Integer relativeRowIndex, Boolean isHead) {
        }
    }
}

