package com.elitescloud.boot.excel.common;

/**
 * 常量类.
 *
 * @author Kaiser（wang shao）
 * @date 2023/11/22
 */
public interface ExcelConstant {
    /**
     * 默认模板ID
     */
    long DEFAULT_TMPL_ID = -1;

    /**
     * 单个sheet中最多的行数
     */
    int SHEET_ROW_MAX = 1000000;

    /**
     * 环境变量：导出数据量限制
     */
    String PROPERTY_EXPORT_LIMIT = "_YST_CORE_EXPORT_LIMIT";

    /**
     * 自定义要导出的列
     */
    String PARAM_EXPORT_FIELD = "exportColumn";

    /**
     * 自定义导出的扩展字段
     */
    String PARAM_EXPORT_FIELD_EXTENSION = "extensionColumn";

    /**
     * 扩展字段的前缀
     */
    String EXTENSION_FIELD_PREFIX = "extension.";

    /**
     * 扩展信息属性
     */
    String EXTENSION_PROPERTY = "extensionInfo";
}
