package com.elitescloud.boot.excel.config.tmpl;

import com.el.coordinator.boot.fsm.service.FileService;
import com.elitescloud.boot.common.param.AbstractOrderQueryParam;
import com.elitescloud.boot.datasecurity.common.DataSecurityUtil;
import com.elitescloud.boot.datasecurity.config.DataSecurityProperties;
import com.elitescloud.boot.excel.common.DataExport;
import com.elitescloud.boot.excel.common.DataImport;
import com.elitescloud.boot.excel.common.support.ExportedDataFormatter;
import com.elitescloud.boot.excel.common.support.TmplApiService;
import com.elitescloud.boot.excel.config.ExcelProperties;
import com.elitescloud.boot.excel.config.tmpl.export.SystemTmplDataSupport;
import com.elitescloud.boot.excel.config.tmpl.export.strategy.TmplExportStrategyDelegate;
import com.elitescloud.boot.excel.support.FieldPermissionExportedDataFormatter;
import com.elitescloud.boot.redis.util.RedisUtils;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.core.task.TaskExecutor;

import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 根据模板文件导入导出配置.
 *
 * @author Kaiser（wang shao）
 * @date 2/17/2023
 */
@Import({TmplConfig.DataSecurityConfig.class})
@ConditionalOnClass({FileService.class})
public class TmplConfig {

    private final TmplApiService tmplApiService;
    private final RedisUtils redisUtils;
    private final FileService<?> fileService;

    public TmplConfig(TmplApiService tmplApiService, RedisUtils redisUtils, FileService<?> fileService) {
        this.tmplApiService = tmplApiService;
        this.redisUtils = redisUtils;
        this.fileService = fileService;
    }

    @Bean
    SystemTmplDataSupport systemTmplDataSupport() {
        return new SystemTmplDataSupport(tmplApiService, redisUtils, fileService);
    }

    @Bean
    DataImportServiceFactory systemDataImportServiceFactory(ObjectProvider<DataImport<?/* extends Serializable*/>> dataImportProvider) {
        var dataImportList = dataImportProvider.stream().collect(Collectors.toList());
        return new DataImportServiceFactory(dataImportList);
    }

    @Bean
    DataExportServiceFactory systemDataExportServiceFactory(ObjectProvider<DataExport<? extends Serializable, ? extends AbstractOrderQueryParam>> dataExportProvider) {
        var dataExportList = dataExportProvider.stream().collect(Collectors.toList());
        return new DataExportServiceFactory(dataExportList);
    }

    @Bean
    TmplDataService tmplDataService(ExcelProperties excelProperties,
                                    SystemTmplDataSupport systemTmplDataSupport,
                                    DataImportServiceFactory dataImportServiceFactory,
                                    DataExportServiceFactory dataExportServiceFactory,
                                    TmplExportStrategyDelegate exportStrategyDelegate,
                                    TaskExecutor taskExecutor,
                                    ObjectMapper objectMapper,
                                    List<ExportedDataFormatter> exportedDataFormatters) {
        return new TmplDataService(excelProperties, fileService, systemTmplDataSupport, dataImportServiceFactory,
                dataExportServiceFactory, exportStrategyDelegate, taskExecutor, objectMapper, exportedDataFormatters);
    }

    @Bean
    TmplDataController tmplDataController(TmplDataService tmplDataService) {
        return new TmplDataController(tmplDataService);
    }

    @Bean
    TmplExportStrategyDelegate tmplExportStrategyDelegate(SystemTmplDataSupport fsmTmplSupport) {
        return new TmplExportStrategyDelegate(fileService, fsmTmplSupport);
    }

    @ConditionalOnClass(DataSecurityUtil.class)
    static class DataSecurityConfig {

        @Bean
        @ConditionalOnProperty(prefix = DataSecurityProperties.CONFIG_PREFIX, name = "enabled", havingValue = "true", matchIfMissing = true)
        public FieldPermissionExportedDataFormatter fieldPermissionExportedDataFormatter() {
            return new FieldPermissionExportedDataFormatter();
        }
    }
}
