package com.elitescloud.boot.excel.config.tmpl.converter;

import cn.hutool.core.text.CharSequenceUtil;
import com.alibaba.excel.enums.CellDataTypeEnum;
import com.alibaba.excel.metadata.CellData;
import com.alibaba.excel.metadata.GlobalConfiguration;
import com.alibaba.excel.metadata.property.ExcelContentProperty;
import com.elitescloud.boot.excel.common.support.CustomConverter;

/**
 * 布尔值转换器.
 *
 * @author Kaiser（wang shao）
 * @date 2024/1/16
 */
class BooleanConverter implements CustomConverter<Boolean> {

    private static final String Y = "是";
    private static final String N = "否";

    @Override
    public Class<Boolean> supportJavaTypeKey() {
        return Boolean.class;
    }

    @Override
    public CellDataTypeEnum supportExcelTypeKey() {
        return CellDataTypeEnum.STRING;
    }

    @Override
    public Boolean convertToJavaData(CellData cellData, ExcelContentProperty contentProperty, GlobalConfiguration globalConfiguration) throws Exception {
        var strValue = cellData.getDataFormatString();
        if (CharSequenceUtil.isBlank(strValue)) {
            return null;
        }
        strValue = strValue.toLowerCase();
        switch (strValue) {
            case Y:
            case "true":
                return true;
            default:
                return false;
        }
    }

    @Override
    public CellData<String> convertToExcelData(Boolean value, ExcelContentProperty contentProperty, GlobalConfiguration globalConfiguration) throws Exception {
        if (value == null) {
            return new CellData<>("");
        }
        return new CellData<>(value ? Y : N);
    }
}
