package com.elitescloud.boot.excel.config.tmpl.converter;

import com.alibaba.excel.converters.Converter;
import com.elitescloud.boot.SpringContextHolder;
import com.elitescloud.boot.excel.common.support.CustomConverter;

import java.util.ArrayList;
import java.util.List;

/**
 * 转换器工厂.
 *
 * @author Kaiser（wang shao）
 * @date 2024/1/16
 */
public class ConverterFactory {

    private ConverterFactory() {
    }

    /**
     * 获取所有的转换器
     *
     * @return 转换器列表
     */
    public static List<Converter<?>> getConvertersAll() {
        List<Converter<?>> converters = new ArrayList<>(16);

        // 内置的
        converters.addAll(getConvertersInternal());

        // 自定义的
        converters.addAll(getConvertersCustom());

        return converters;
    }

    /**
     * 获取所有的转换器
     *
     * @return 转换器列表
     */
    public static List<Converter<?>> getConvertersInternal() {
        List<Converter<?>> converters = new ArrayList<>(16);

        // 内置的
        converters.add(new BigDecimalNumberConverter());
        converters.add(new BooleanConverter());
        converters.add(new DateConverter());
        converters.add(new LocalDateConverter());
        converters.add(new LocalDateTimeConverter());
        converters.add(new LocalTimeConverter());

        return converters;
    }

    /**
     * 获取所有的转换器
     *
     * @return 转换器列表
     */
    public static List<Converter<?>> getConvertersCustom() {
        List<Converter<?>> converters = new ArrayList<>(16);
        // 自定义的
        SpringContextHolder.getObjectProvider(CustomConverter.class)
                .forEach(converters::add);

        return converters;
    }
}
