package com.elitescloud.boot.excel.config.tmpl.converter;

import cn.hutool.core.text.CharSequenceUtil;
import com.alibaba.excel.enums.CellDataTypeEnum;
import com.alibaba.excel.metadata.CellData;
import com.alibaba.excel.metadata.GlobalConfiguration;
import com.alibaba.excel.metadata.property.ExcelContentProperty;
import com.elitescloud.boot.excel.common.support.CustomConverter;
import com.elitescloud.boot.util.DatetimeUtil;

import java.time.LocalDate;

/**
 * 日期转换器.
 *
 * @author Kaiser（wang shao）
 * @date 2024/1/16
 */
class LocalDateConverter implements CustomConverter<LocalDate> {

    @Override
    public Class<LocalDate> supportJavaTypeKey() {
        return LocalDate.class;
    }

    @Override
    public CellDataTypeEnum supportExcelTypeKey() {
        return CellDataTypeEnum.STRING;
    }

    @Override
    public LocalDate convertToJavaData(CellData cellData, ExcelContentProperty contentProperty, GlobalConfiguration globalConfiguration) throws Exception {
        var strValue = cellData.getDataFormatString();
        return DatetimeUtil.parseLocalDate(strValue);
    }

    @Override
    public CellData<String> convertToExcelData(LocalDate value, ExcelContentProperty contentProperty, GlobalConfiguration globalConfiguration) throws Exception {
        var strValue = value == null ? "" : DatetimeUtil.toStr(value);
        return new CellData<>(strValue);
    }
}
