package com.elitescloud.boot.excel.config.tmpl.converter;

import com.alibaba.excel.enums.CellDataTypeEnum;
import com.alibaba.excel.metadata.CellData;
import com.alibaba.excel.metadata.GlobalConfiguration;
import com.alibaba.excel.metadata.property.ExcelContentProperty;
import com.elitescloud.boot.excel.common.support.CustomConverter;
import com.elitescloud.boot.util.DatetimeUtil;

import java.time.LocalTime;

/**
 * 时间转换器.
 *
 * @author Kaiser（wang shao）
 * @date 2024/1/16
 */
class LocalTimeConverter implements CustomConverter<LocalTime> {

    @Override
    public Class<LocalTime> supportJavaTypeKey() {
        return LocalTime.class;
    }

    @Override
    public CellDataTypeEnum supportExcelTypeKey() {
        return CellDataTypeEnum.STRING;
    }

    @Override
    public LocalTime convertToJavaData(CellData cellData, ExcelContentProperty contentProperty, GlobalConfiguration globalConfiguration) throws Exception {
        var strValue = cellData.getDataFormatString();
        return DatetimeUtil.parseLocalTime(strValue);
    }

    @Override
    public CellData<String> convertToExcelData(LocalTime value, ExcelContentProperty contentProperty, GlobalConfiguration globalConfiguration) throws Exception {
        var strValue = value == null ? "" : DatetimeUtil.toStr(value);
        return new CellData<>(strValue);
    }
}
