package com.elitescloud.boot.excel.config.tmpl.export;

import org.springframework.util.StopWatch;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * 导出耗时信息.
 *
 * @author Kaiser（wang shao）
 * @date 2024/2/8
 */
public class ExportCostTime implements CostTime {

    private StopWatch prepare;
    private StopWatch queryData;
    private StopWatch convertData;
    private StopWatch writeData;
    private StopWatch updateResult;

    private ExportCostTime() {
    }

    @Override
    public String shortSummary() {
        List<String> result = new ArrayList<>();
        result.add(CostTime.PREPARE + ":" + prepare.getTotalTimeMillis());
        result.add(CostTime.DATA_READ + ":" + queryData.getTotalTimeMillis());
        result.add(CostTime.DATA_CONVERT + ":" + convertData.getTotalTimeMillis());
        result.add(CostTime.DATA_WRITE + ":" + writeData.getTotalTimeMillis());
        result.add(CostTime.UPDATE_RESULT + ":" + updateResult.getTotalTimeMillis());

        return String.join(";", result);
    }

    public static ExportCostTime getInstance() {
        ExportCostTime exportCostTime = new ExportCostTime();
        exportCostTime.prepare = new StopWatch();
        exportCostTime.queryData = new StopWatch();
        exportCostTime.convertData = new StopWatch();
        exportCostTime.writeData = new StopWatch();
        exportCostTime.updateResult = new StopWatch();
        return exportCostTime;
    }

    public StopWatch getPrepare() {
        return prepare;
    }

    public StopWatch getQueryData() {
        return queryData;
    }

    public StopWatch getConvertData() {
        return convertData;
    }

    public StopWatch getWriteData() {
        return writeData;
    }

    public StopWatch getUpdateResult() {
        return updateResult;
    }
}
