package com.elitescloud.boot.excel.config.tmpl.export;

import com.elitescloud.boot.common.param.AbstractOrderQueryParam;
import com.elitescloud.boot.excel.support.TmplDataExportWrapper;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.dto.SysTmplDTO;

import java.io.Serializable;
import java.util.function.Function;

/**
 * 导出策略参数.
 *
 * @author Kaiser（wang shao）
 * @date 2022/11/28
 */
public class ExportStrategyParam<R extends Serializable, P extends AbstractOrderQueryParam> {

    private boolean sync;
    private Long importId;
    private TmplDataExportWrapper tmplWrapper;
    private PagingVO<R> firstPageData;
    private P queryParam;
    private Function<P, PagingVO<R>> dataProvider;
    private String exportFileName;
    private int pageSize;
    private ExportCostTime costTime;

    public boolean isSync() {
        return sync;
    }

    public ExportStrategyParam<R, P> setSync(boolean sync) {
        this.sync = sync;
        return this;
    }

    public Long getImportId() {
        return importId;
    }

    public ExportStrategyParam<R, P> setImportId(Long importId) {
        this.importId = importId;
        return this;
    }

    public SysTmplDTO getTmplDTO() {
        return tmplWrapper.getTmplDTO();
    }

    public ExportStrategyParam<R, P> setTmplExportWrapper(TmplDataExportWrapper tmplWrapper) {
        this.tmplWrapper = tmplWrapper;
        return this;
    }

    public TmplDataExportWrapper getTmplWrapper() {
        return tmplWrapper;
    }

    public PagingVO<R> getFirstPageData() {
        return firstPageData;
    }

    public ExportStrategyParam<R, P> setFirstPageData(PagingVO<R> firstPageData) {
        this.firstPageData = firstPageData;
        return this;
    }

    public P getQueryParam() {
        return queryParam;
    }

    public ExportStrategyParam<R, P> setQueryParam(P queryParam) {
        this.queryParam = queryParam;
        return this;
    }

    public Function<P, PagingVO<R>> getDataProvider() {
        return dataProvider;
    }

    public ExportStrategyParam<R, P> setDataProvider(Function<P, PagingVO<R>> dataProvider) {
        this.dataProvider = dataProvider;
        return this;
    }

    public String getExportFileName() {
        return exportFileName;
    }

    public ExportStrategyParam<R, P> setExportFileName(String exportFileName) {
        this.exportFileName = exportFileName;
        return this;
    }

    public int getPageSize() {
        return pageSize;
    }

    public ExportStrategyParam<R, P> setPageSize(int pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    public ExportCostTime getCostTime() {
        return costTime;
    }

    public ExportStrategyParam<R, P> setCostTime(ExportCostTime costTime) {
        this.costTime = costTime;
        return this;
    }
}
