package com.elitescloud.boot.excel.config.tmpl.export.strategy;

import com.alibaba.excel.write.metadata.WriteSheet;
import com.el.coordinator.boot.fsm.service.FileService;
import com.elitescloud.boot.common.param.AbstractOrderQueryParam;
import com.elitescloud.boot.excel.config.tmpl.export.ExportStrategyParam;
import com.elitescloud.boot.excel.config.tmpl.export.SystemTmplDataSupport;
import com.elitescloud.cloudt.system.dto.SysImportRateDTO;
import com.fasterxml.jackson.databind.ObjectMapper;

import java.io.Serializable;

/**
 * 超出sheet限制后剩余的数据忽略.
 *
 * @author Kaiser（wang shao）
 * @date 2022/11/28
 */
class IgnoreExportStrategy<R extends Serializable, P extends AbstractOrderQueryParam> extends BaseExportStrategy<R, P> {

    public IgnoreExportStrategy(FileService<?> fileService, SystemTmplDataSupport fsmTmplSupport, ObjectMapper objectMapper) {
        super(fileService, fsmTmplSupport, objectMapper);
    }

    @Override
    public long export(ExportStrategyParam<R, P> param) throws Exception {
        int sheetLimit = sheetLimit(param.getTmplDTO());
        int sheetIndex = 0;
        int page = 2;
        var pageSize = param.getPageSize();
        int count = 0;

        var excelFile = createExportFile(param);
        var excelWriter = super.createExcelWriter(excelFile);
        WriteSheet sheet = super.createSheet(sheetIndex, param.getTmplWrapper());

        // 开始写数据
        var pageData = param.getFirstPageData();
        param.getCostTime().getPrepare().stop();

        while (pageData.isNotEmpty()) {
            var tempDataList = pageData.getRecords();
            if (count + pageData.size() > sheetLimit) {
                // 超出限制了，截取一部分，忽略多余的
                tempDataList = pageData.getRecords().subList(0, sheetLimit - count);
            }
            count += tempDataList.size();

            // 转换并向excel写入数据
            super.convertAndWrite(excelWriter, sheet, param.getTmplWrapper(), tempDataList, param.getCostTime());

            // 少于页大小，则说明没有数据了
            var isFinish = pageData.size() < pageSize || count >= sheetLimit;
            if (!param.isSync()) {
                param.getCostTime().getUpdateResult().start();
                // 异步时更新进度
                super.updateRate(param.getImportId(), SysImportRateDTO.builder()
                        .finish(false)
                        .total(pageData.getTotal())
                        .count((long) count - 1)
                        .tmplCode(param.getTmplDTO().getCode())
                        .build());
                param.getCostTime().getUpdateResult().stop();
            }
            if (isFinish) {
                break;
            }

            // 查询下一页数据
            param.getCostTime().getQueryData().start();
            param.getQueryParam().setCurrent(page);
            param.getQueryParam().setSize(pageSize);
            pageData = param.getDataProvider().apply(param.getQueryParam());
            param.getCostTime().getQueryData().stop();
            page++;
        }
        excelWriter.finish();
        // 复制头部
        super.copyHeaders(excelFile, sheetIndex + 1, param.getTmplWrapper());

        // 更新导出结果
        param.getCostTime().getUpdateResult().start();
        updateExportFinish(param, (long) count, excelFile, param.getCostTime());
        excelFile.deleteOnExit();
        param.getCostTime().getUpdateResult().stop();

        return count;
    }
}
