package com.elitescloud.boot.excel.support;

import cn.hutool.core.collection.CollUtil;
import com.elitescloud.boot.common.annotation.BusinessObjectOperation;
import com.elitescloud.boot.datasecurity.common.DataSecurityUtil;
import com.elitescloud.boot.excel.common.support.ExportedDataFormatter;
import com.elitescloud.boot.excel.config.tmpl.DataExportServiceFactory;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 字段权限过滤.
 *
 * @author Kaiser（wang shao）
 * @date 2024/4/19
 */
public class FieldPermissionExportedDataFormatter implements ExportedDataFormatter {

    private final Map<Class<?>, Boolean> autoFilterMap = new HashMap<>(32);

    @Override
    public <T extends Serializable> void format(DataExportServiceFactory.ServiceMetaData dataExportService, List<T> dataList) {
        if (CollUtil.isEmpty(dataList)) {
            return;
        }

        var autoFilter = autoFilterMap.computeIfAbsent(dataExportService.getDataExportClass(), t -> isSupportAutoFilter(dataExportService));
        if (Boolean.TRUE.equals(autoFilter)) {
            DataSecurityUtil.eraseByFieldPermission(dataList);
        }
    }

    private boolean isSupportAutoFilter(DataExportServiceFactory.ServiceMetaData serviceMetaData) {
        var businessObjectOperation = serviceMetaData.getMethod().getAnnotation(BusinessObjectOperation.class);
        return businessObjectOperation != null && businessObjectOperation.fieldPermissionAutoFilter();
    }
}
