package com.elitescloud.cloudt.system.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * 导入导出进度.
 *
 * @author Kaiser（wang shao）
 * @date 3/20/2023
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class SysImportRateDTO implements Serializable {
    private static final long serialVersionUID = -3232588826593197413L;

    /**
     * 是否处理完毕
     */
    private Boolean finish;

    /**
     * 模板编号
     */
    private String tmplCode;

    /**
     * 记录总数
     */
    private Long total;

    /**
     * 已导入数量
     */
    private Long count;

    /**
     * 处理成功的数量
     */
    private Long numSuccess;

    /**
     * 失败记录的文件编码
     */
    private String failFileCode;

    /**
     * 自定义失败信息，空则使用系统默认的
     */
    private String failMsgCustom;
}
