/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.excel.config.tmpl;

import cn.hutool.core.collection.CollUtil;
import com.elitescloud.boot.common.param.AbstractOrderQueryParam;
import com.elitescloud.boot.excel.common.DataExport;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.util.ClassUtil;
import com.elitescloud.cloudt.common.base.PagingVO;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.framework.AopProxyUtils;
import org.springframework.util.Assert;

public class DataExportServiceFactory {
    private static final Logger log = LoggerFactory.getLogger(DataExportServiceFactory.class);
    private final Map<String, ServiceMetaData> dataExportMap = new HashMap<String, ServiceMetaData>(64);

    public DataExportServiceFactory(List<DataExport<?, ?>> dataExportList) {
        this.init(dataExportList);
    }

    public boolean isSupport(String tmplCode) {
        return this.dataExportMap.containsKey(tmplCode);
    }

    public ServiceMetaData getDataExportService(String tmplCode) {
        return this.dataExportMap.get(tmplCode);
    }

    public Map<String, ServiceMetaData> getAllExportService() {
        return Collections.unmodifiableMap(this.dataExportMap);
    }

    private void init(List<DataExport<? extends Serializable, ? extends AbstractOrderQueryParam>> dataExportList) {
        if (CollUtil.isEmpty(dataExportList)) {
            return;
        }
        for (DataExport<? extends Serializable, ? extends AbstractOrderQueryParam> dataExport : dataExportList) {
            if (!this.dataExportMap.containsKey(dataExport.getTmplCode())) continue;
            throw new BusinessException("\u5b58\u5728\u91cd\u590d\u7684\u6570\u636e\u5bfc\u51fa\u670d\u52a1\uff1a" + dataExport.getTmplCode());
        }
        CompletableFuture.runAsync(() -> {
            for (DataExport dataExport : dataExportList) {
                try {
                    this.dataExportMap.put(dataExport.getTmplCode(), new ServiceMetaData(dataExport));
                }
                catch (Exception e) {
                    log.error("\u52a0\u8f7d\u6587\u4ef6\u5bfc\u51fa\u670d\u52a1\u5f02\u5e38\uff1a{}, {}", (Object)dataExport.getTmplCode(), (Object)ClassUtil.getTargetClass((Object)dataExport).getName());
                    throw e;
                }
            }
        }).whenComplete((r, e) -> {
            if (e != null) {
                log.error("\u521d\u59cb\u5316\u6570\u636e\u5bfc\u51fa\u670d\u52a1\u5f02\u5e38\uff1a", e);
                return;
            }
            log.info("initialized DataExportService\uff1a{}", (Object)String.join((CharSequence)",", this.dataExportMap.keySet()));
        });
    }

    public static class ServiceMetaData {
        private final DataExport dataExport;
        private final Class<? extends Serializable> dataType;
        private final Class<? extends AbstractOrderQueryParam> paramType;
        private final Class<?> dataExportClass;
        private final Method method;
        private final boolean hasNewExportMethod;
        private final Method exportMethod;
        private final Method exportMethodCompatible;

        public <T extends DataExport<R, P>, R extends Serializable, P extends AbstractOrderQueryParam> ServiceMetaData(T dataExport) {
            this.dataExport = dataExport;
            this.dataExportClass = AopProxyUtils.ultimateTargetClass(dataExport);
            Type[] arguments = ((ParameterizedType)this.dataExportClass.getGenericInterfaces()[0]).getActualTypeArguments();
            this.dataType = (Class)arguments[0];
            this.paramType = (Class)arguments[1];
            this.method = this.obtainMethod(this.dataExportClass, this.paramType);
            Assert.notNull((Object)this.method, () -> this.dataExportClass.getName() + "\u672a\u53d1\u73b0\u6709\u6548\u7684\u5bfc\u51fa\u65b9\u6cd5");
            this.exportMethod = this.obtainExportMethod(dataExport, this.paramType);
            this.exportMethodCompatible = this.obtainExportMethodCompatible(dataExport, this.paramType);
            Assert.isTrue((this.exportMethod != null || this.exportMethodCompatible != null ? 1 : 0) != 0, () -> this.dataExportClass.getName() + "\u672a\u627e\u5230\u5bfc\u51fa\u6570\u636e\u7684executeExport\u65b9\u6cd5");
            boolean bl = this.hasNewExportMethod = this.exportMethod != null;
            if (!this.hasNewExportMethod) {
                log.warn("{}\u4f7f\u7528\u4e86\u8fc7\u671f\u7684\u5bfc\u51fa\u65b9\u6cd5\uff0c\u8bf7\u5c3d\u5feb\u5207\u6362\u6210\u6700\u65b0\u7684\u5bfc\u51fa\u65b9\u6cd5executeExport()", (Object)this.dataExportClass.getName());
            }
        }

        public DataExport getDataExport() {
            return this.dataExport;
        }

        public Method getExportMethod() {
            return this.exportMethod;
        }

        public Class<?> getDataExportClass() {
            return this.dataExportClass;
        }

        public Method getMethod() {
            return this.method;
        }

        public Method getExportMethodCompatible() {
            return this.exportMethodCompatible;
        }

        public Class<? extends Serializable> getDataType() {
            return this.dataType;
        }

        public Class<? extends AbstractOrderQueryParam> getParamType() {
            return this.paramType;
        }

        public boolean isHasNewExportMethod() {
            return this.hasNewExportMethod;
        }

        public <R extends Serializable, P extends AbstractOrderQueryParam> PagingVO<R> applyExport(P params, boolean useReflect) {
            try {
                if (useReflect) {
                    if (this.exportMethod != null) {
                        return (PagingVO)this.exportMethod.invoke((Object)this.dataExport, params);
                    }
                    if (this.exportMethodCompatible != null) {
                        return (PagingVO)this.exportMethodCompatible.invoke((Object)this.dataExport, params, params.getCurrent() + 1, params.getSize());
                    }
                }
                if (this.hasNewExportMethod) {
                    return this.dataExport.executeExport(params);
                }
                return this.dataExport.execute(params, params.getCurrent() + 1, params.getSize());
            }
            catch (Throwable e) {
                throw new BusinessException("\u5bfc\u51fa\u6570\u636e\u5f02\u5e38", e);
            }
        }

        public <P extends AbstractOrderQueryParam> Class<P> applyGetParamType() {
            return this.paramType;
        }

        public String applyGetExportFileName() {
            return this.dataExport.exportFileName();
        }

        public int applyGetPageSize() {
            Integer pageSize = this.dataExport.pageSize();
            if (pageSize == null || pageSize < 1) {
                return 50;
            }
            return pageSize;
        }

        public boolean applyIsRequiredTmpl() {
            return Boolean.TRUE.equals(this.dataExport.requireTmpl());
        }

        private Method obtainMethod(Class<?> exportServiceClass, Class<?> paramType) {
            try {
                return exportServiceClass.getMethod("executeExport", paramType);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                try {
                    return exportServiceClass.getMethod("execute", paramType, Integer.TYPE, Integer.TYPE);
                }
                catch (NoSuchMethodException noSuchMethodException2) {
                    return null;
                }
            }
        }

        private Method obtainExportMethod(Object dataExport, Class<?> paramType) {
            try {
                return dataExport.getClass().getDeclaredMethod("executeExport", paramType);
            }
            catch (Throwable throwable) {
                return null;
            }
        }

        private Method obtainExportMethodCompatible(Object dataExport, Class<?> paramType) {
            try {
                return dataExport.getClass().getDeclaredMethod("execute", paramType, Integer.TYPE, Integer.TYPE);
            }
            catch (Throwable throwable) {
                return null;
            }
        }
    }
}

