/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.excel.config.tmpl.export.strategy;

import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.elitescloud.boot.common.param.AbstractOrderQueryParam;
import com.elitescloud.boot.excel.config.tmpl.export.ExportStrategyParam;
import com.elitescloud.boot.excel.config.tmpl.export.SystemTmplDataSupport;
import com.elitescloud.boot.excel.config.tmpl.export.strategy.BaseExportStrategy;
import com.elitescloud.boot.provider.FileProvider;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.dto.SysImportRateDTO;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.Serializable;
import java.util.List;

class NewSheetExportStrategy<R extends Serializable, P extends AbstractOrderQueryParam>
extends BaseExportStrategy<R, P> {
    public NewSheetExportStrategy(FileProvider fileProvider, SystemTmplDataSupport fsmTmplSupport, ObjectMapper objectMapper) {
        super(fileProvider, fsmTmplSupport, objectMapper);
    }

    @Override
    public long export(ExportStrategyParam<R, P> param) throws Exception {
        int sheetLimit = this.sheetLimit(param.getTmplDTO());
        int page = 2;
        int pageSize = param.getPageSize();
        long count = 0L;
        int sheetIndex = 0;
        int rowCount = 0;
        File excelFile = this.createExportFile(param);
        ExcelWriter excelWriter = super.createExcelWriter(excelFile);
        WriteSheet sheet = super.createSheet(sheetIndex, param.getTmplWrapper());
        PagingVO<R> pageData = param.getFirstPageData();
        param.getCostTime().getPrepare().stop();
        while (pageData.isNotEmpty()) {
            boolean isFinish;
            if (rowCount == sheetLimit) {
                rowCount = 0;
                sheet = super.createSheet(++sheetIndex, param.getTmplWrapper());
            }
            List tempDataList = pageData.getRecords();
            if (rowCount + pageData.size() > sheetLimit) {
                int start = 0;
                int end = start + (sheetLimit - rowCount);
                tempDataList = pageData.getRecords().subList(start, end);
                while (end < pageData.size()) {
                    super.convertAndWrite(excelWriter, sheet, param.getTmplWrapper(), tempDataList, param.getCostTime());
                    int newEnd = end + (sheetLimit - rowCount);
                    sheet = super.createSheet(++sheetIndex, param.getTmplWrapper());
                    tempDataList = pageData.getRecords().subList(end, Math.min(pageData.size(), newEnd));
                    rowCount = 0;
                    end = newEnd;
                }
            }
            rowCount += tempDataList.size();
            super.convertAndWrite(excelWriter, sheet, param.getTmplWrapper(), tempDataList, param.getCostTime());
            boolean bl = isFinish = pageData.size() < pageSize || pageData.getTotal() <= (count += (long)pageData.size());
            if (!param.isSync()) {
                param.getCostTime().getUpdateResult().start();
                super.updateRate(param.getImportId(), SysImportRateDTO.builder().finish(false).total(pageData.getTotal()).count(count - 1L).tmplCode(param.getTmplDTO().getCode()).build());
                param.getCostTime().getUpdateResult().stop();
            }
            if (isFinish) break;
            param.getCostTime().getQueryData().start();
            param.getQueryParam().setCurrent(Integer.valueOf(page));
            param.getQueryParam().setSize(Integer.valueOf(pageSize));
            pageData = param.getDataProvider().apply(param.getQueryParam());
            param.getCostTime().getQueryData().stop();
            ++page;
        }
        excelWriter.finish();
        super.copyHeaders(excelFile, sheetIndex + 1, param.getTmplWrapper());
        param.getCostTime().getUpdateResult().start();
        this.updateExportFinish(param, count, excelFile, param.getCostTime());
        excelFile.deleteOnExit();
        param.getCostTime().getUpdateResult().stop();
        return count;
    }
}

