/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.excel.support;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.excel.EasyExcelFactory;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.converters.Converter;
import com.alibaba.excel.write.builder.ExcelWriterBuilder;
import com.alibaba.excel.write.builder.ExcelWriterSheetBuilder;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.elitescloud.boot.common.CloudtBootLoggerFactory;
import com.elitescloud.boot.excel.common.param.AbstractExportQueryParam;
import com.elitescloud.boot.excel.common.support.ExcelExportProperties;
import com.elitescloud.boot.excel.config.tmpl.converter.ConverterFactory;
import com.elitescloud.boot.excel.util.ExcelUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.base.param.ExportColumnParam;
import com.elitescloud.cloudt.core.service.ExportExcelService;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.springframework.core.task.TaskExecutor;
import org.springframework.http.ContentDisposition;
import org.springframework.util.StopWatch;

public class ExportExcelServiceImpl<T extends AbstractExportQueryParam, R extends Serializable, E extends Serializable>
implements ExportExcelService<T, R, E> {
    private static final Logger logger = CloudtBootLoggerFactory.EXCEL_EXPORT.getLogger(ExportExcelServiceImpl.class);
    private final ExcelExportProperties exportExcelProperties;
    private final TaskExecutor taskExecutor;
    private final ObjectMapper objectMapper;
    private final DateTimeFormatter formatterLong = DateTimeFormatter.ofPattern("yyyyMMddHHmmssSSS");
    private List<Converter<?>> converters;

    public ExportExcelServiceImpl(ExcelExportProperties exportExcelProperties, TaskExecutor taskExecutor) {
        this.exportExcelProperties = exportExcelProperties;
        this.taskExecutor = taskExecutor;
        this.objectMapper = ExcelUtil.buildObjectMapper();
    }

    @Override
    public Boolean exportSync(T queryParam, HttpServletResponse response, Function<T, PagingVO<R>> dataService) {
        try {
            return this.export(queryParam, response, dataService).get();
        }
        catch (Exception e) {
            throw new BusinessException("\u5bfc\u51fa\u5931\u8d25", (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<Boolean> export(T queryParam, HttpServletResponse response, Function<T, PagingVO<R>> dataService) {
        return this.export(queryParam, response, dataService, null);
    }

    @Override
    public Boolean exportSync(T queryParam, HttpServletResponse response, Function<T, PagingVO<R>> dataService, Function<R, List<E>> detailData) {
        try {
            return this.export(queryParam, response, dataService, detailData).get();
        }
        catch (Exception e) {
            throw new BusinessException("\u5bfc\u51fa\u5931\u8d25", (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<Boolean> export(T queryParam, HttpServletResponse response, Function<T, PagingVO<R>> dataService, Function<R, List<E>> detailData) {
        return CompletableFuture.supplyAsync(() -> this.execute(queryParam, response, dataService, detailData), (Executor)this.taskExecutor).exceptionally(e -> {
            logger.error("\u5bfc\u51faexcel\u6587\u4ef6\u5931\u8d25", e);
            response.reset();
            response.setContentType("application/json");
            response.setCharacterEncoding(StandardCharsets.UTF_8.name());
            try {
                response.getWriter().println(this.objectMapper.writeValueAsString((Object)ApiResult.fail((String)"\u5bfc\u51fa\u6587\u4ef6\u5931\u8d25")));
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            return true;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean execute(T queryParam, HttpServletResponse response, Function<T, PagingVO<R>> dataService, Function<R, List<E>> detailData) {
        logger.info("\u5f00\u59cb\u5bfc\u51fa\u6570\u636e...");
        StopWatch watch = new StopWatch();
        watch.start();
        this.checkBeforeExport(queryParam, detailData);
        response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        response.setCharacterEncoding(StandardCharsets.UTF_8.name());
        String fileName = CharSequenceUtil.blankToDefault((CharSequence)((AbstractExportQueryParam)((Object)queryParam)).getFileName(), (String)(this.formatterLong.format(LocalDateTime.now()) + ".xlsx"));
        response.setHeader("Content-Disposition", ContentDisposition.builder((String)"attachment").filename(fileName, StandardCharsets.UTF_8).build().toString());
        ServletOutputStream outputStream = null;
        try {
            outputStream = response.getOutputStream();
        }
        catch (IOException e) {
            throw new BusinessException("\u5bfc\u51fa\u6570\u636e\u5f02\u5e38");
        }
        ExcelWriterBuilder excelWriterBuilder = ((ExcelWriterBuilder)((ExcelWriterBuilder)EasyExcelFactory.write((OutputStream)outputStream).useDefaultStyle(Boolean.valueOf(true))).autoTrim(Boolean.valueOf(true))).writeExcelOnException(Boolean.valueOf(true));
        for (Converter<?> converter : this.getConverters()) {
            excelWriterBuilder.registerConverter(converter);
        }
        ExcelWriter excelWriter = excelWriterBuilder.build();
        StopWatch watchData = null;
        try {
            watchData = this.writeData(excelWriter, queryParam, dataService, detailData);
        }
        finally {
            excelWriter.finish();
        }
        watch.stop();
        logger.info("\u5bfc\u51fa\u6570\u636e\u7ed3\u675f\uff0c\u5171\u7528\u65f6{}s\uff0c\u5176\u4e2d\u67e5\u8be2\u4e1a\u52a1\u6570\u636e\u5171\u7528\u65f6{}s\uff01", (Object)watch.getTotalTimeSeconds(), (Object)watchData.getTotalTimeSeconds());
        return true;
    }

    private void checkBeforeExport(T queryParam, Function<R, List<E>> detailData) {
        if (queryParam == null) {
            throw new BusinessException("\u672a\u77e5\u5bfc\u51fa\u5217");
        }
        queryParam.setCurrent(Integer.valueOf(NumberUtil.max((int[])new int[]{1, (Integer)ObjectUtil.defaultIfNull((Object)queryParam.getCurrent(), (Object)1)})));
        queryParam.setSize(Integer.valueOf(NumberUtil.max((int[])new int[]{50, (Integer)ObjectUtil.defaultIfNull((Object)queryParam.getSize(), (Object)10)})));
        if (CollUtil.isEmpty(((AbstractExportQueryParam)((Object)queryParam)).getExportColumn())) {
            throw new BusinessException("\u672a\u77e5\u5bfc\u51fa\u5217");
        }
        if (CollUtil.isNotEmpty(((AbstractExportQueryParam)((Object)queryParam)).getExportDetailColumn()) && detailData == null) {
            throw new BusinessException("\u65e0\u6cd5\u83b7\u53d6\u8be6\u7ec6\u6570\u636e");
        }
    }

    private StopWatch writeData(ExcelWriter excelWriter, T queryParam, Function<T, PagingVO<R>> dataService, Function<R, List<E>> detailData) {
        ExcelWriterSheetBuilder sheetBuilder = new ExcelWriterSheetBuilder(excelWriter);
        sheetBuilder.sheetName("\u5bfc\u51fa\u6570\u636e");
        Long limit = this.obtainLimitSize();
        Map<String, String> headersMain = this.convertHeaders(((AbstractExportQueryParam)((Object)queryParam)).getExportColumn());
        Map<String, String> headersDetail = this.convertHeaders(((AbstractExportQueryParam)((Object)queryParam)).getExportDetailColumn());
        boolean hasDetail = !headersDetail.isEmpty();
        Collection<String> titles = headersMain.values();
        if (hasDetail) {
            titles = new ArrayList<String>(titles);
            titles.addAll(headersDetail.values());
        }
        List head = titles.stream().map(List::of).collect(Collectors.toList());
        sheetBuilder.head(head);
        WriteSheet sheet = sheetBuilder.build();
        StopWatch watch = new StopWatch();
        watch.start();
        PagingVO<R> data = dataService.apply(queryParam);
        watch.stop();
        Set<String> fieldsMain = headersMain.keySet();
        Set<String> fieldsDetail = headersDetail.keySet();
        List<List<Object>> records = null;
        int page = queryParam.getCurrent() + 1;
        long num = 0L;
        while (data != null && CollUtil.isNotEmpty((Collection)data.getRecords())) {
            records = this.convertRecords(data.getRecords(), fieldsMain, fieldsDetail, detailData, limit, num);
            excelWriter.write(records, sheet);
            if (limit != null && (num += (long)records.size()) >= limit || queryParam.getSize() > data.getRecords().size() || num == data.getTotal()) break;
            queryParam.setCurrent(Integer.valueOf(++page));
            watch.start();
            data = dataService.apply(queryParam);
            watch.stop();
        }
        if (num == 0L) {
            excelWriter.write(null, sheet);
        }
        return watch;
    }

    private Long obtainLimitSize() {
        Long limit = this.exportExcelProperties.getExportLimit();
        return limit == null || limit < 1L ? null : limit;
    }

    private Map<String, String> convertHeaders(List<ExportColumnParam> columnParams) {
        if (CollUtil.isEmpty(columnParams)) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, String> headerMap = new LinkedHashMap<String, String>(columnParams.size());
        for (ExportColumnParam column : columnParams) {
            if (!CharSequenceUtil.isNotBlank((CharSequence)column.getField())) continue;
            headerMap.put(column.getField(), column.getTitle());
        }
        return headerMap;
    }

    private List<List<Object>> convertRecords(List<R> dataList, Set<String> fieldsMain, Set<String> fieldsDetail, Function<R, List<E>> detailData, Long limit, Long num) {
        if (CollUtil.isEmpty(dataList)) {
            return Collections.emptyList();
        }
        Class<?> dataClass = ((Serializable)dataList.get(0)).getClass();
        if (limit != null && num + (long)dataList.size() > limit) {
            dataList = CollUtil.sub(dataList, (int)0, (int)((int)(limit - num)));
        }
        if (detailData == null) {
            return ((List)this.objectMapper.convertValue(dataList, (TypeReference)new TypeReference<List<Map<String, Object>>>(){})).stream().map(data -> fieldsMain.stream().map(d -> this.getValue((Map<String, Object>)data, (String)d, dataClass)).collect(Collectors.toList())).collect(Collectors.toList());
        }
        ArrayList<List<Object>> valueList = new ArrayList<List<Object>>(512);
        for (Serializable data2 : dataList) {
            Map dataMap = (Map)this.objectMapper.convertValue((Object)data2, (TypeReference)new TypeReference<Map<String, Object>>(){});
            List tempValueList = fieldsMain.stream().map(d -> this.getValue(dataMap, (String)d, dataClass)).collect(Collectors.toList());
            List<E> detailList = detailData.apply(data2);
            if (CollUtil.isEmpty(detailList)) {
                valueList.add(tempValueList);
                continue;
            }
            Class<?> dataDetailClass = ((Serializable)detailList.get(0)).getClass();
            List tempDetailValueList = ((List)this.objectMapper.convertValue(detailList, (TypeReference)new TypeReference<List<Map<String, Object>>>(){})).stream().map(detail -> {
                ArrayList temp = new ArrayList(tempValueList);
                temp.addAll(fieldsDetail.stream().map(d -> this.getValue((Map<String, Object>)detail, (String)d, dataDetailClass)).collect(Collectors.toList()));
                return temp;
            }).collect(Collectors.toList());
            valueList.addAll(tempDetailValueList);
        }
        return valueList;
    }

    private Object getValue(Map<String, Object> data, String field, Class<?> dataType) {
        return ExcelUtil.formatExportedValue(data.get(field), field, dataType);
    }

    private List<Converter<?>> getConverters() {
        if (this.converters == null) {
            this.converters = ConverterFactory.getConvertersAll();
        }
        return this.converters;
    }
}

