/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.excel.util;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.boot.SpringContextHolder;
import com.elitescloud.boot.common.CloudtBootLoggerFactory;
import com.elitescloud.boot.common.constant.MimeTypeConstant;
import com.elitescloud.boot.excel.common.TmplRecordStorable;
import com.elitescloud.boot.excel.common.param.AbstractExportQueryParam;
import com.elitescloud.boot.excel.common.param.ExportColumnParam;
import com.elitescloud.boot.excel.common.param.SheetLimitStrategy;
import com.elitescloud.boot.excel.config.ExcelProperties;
import com.elitescloud.boot.excel.config.tmpl.export.ExportCostTime;
import com.elitescloud.boot.excel.support.export.ExportContextParam;
import com.elitescloud.boot.excel.support.export.ExportDataStrategy;
import com.elitescloud.boot.excel.support.export.strategy.IgnoreExportDataStrategy;
import com.elitescloud.boot.excel.support.export.strategy.NewFileExportDataStrategy;
import com.elitescloud.boot.excel.support.export.strategy.NewSheetExportDataStrategy;
import com.elitescloud.boot.excel.support.storage.LogTmplRecordStorage;
import com.elitescloud.boot.excel.util.ExcelUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.util.DatetimeUtil;
import com.elitescloud.boot.util.ObjUtil;
import com.elitescloud.boot.util.ObjectMapperFactory;
import com.elitescloud.cloudt.context.util.HttpServletUtil;
import com.elitescloud.cloudt.system.dto.SysTmplDTO;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.springframework.http.ContentDisposition;
import org.springframework.util.Assert;
import org.springframework.util.StreamUtils;
import org.springframework.util.StringUtils;

public class ExcelExportTemplate {
    private static final Logger logger = CloudtBootLoggerFactory.EXCEL_EXPORT.getLogger(ExcelExportTemplate.class);
    private ExportContextParam exportContextParam;
    private boolean allowTmplAbsent = true;
    private TmplRecordStorable storable;
    private List<ExportColumnParam> columnList;
    private List<ExportColumnParam> extensionColumnList;
    private Instant startTime;
    private Instant finishTime;
    private ExportCostTime costTime;
    private ExportDataStrategy exportDataStrategy;
    private final ObjectMapper objectMapper = ObjectMapperFactory.instance();
    private Class<?> dataType;
    private final TypeReference<List<Map<String, Object>>> dataTypeReference = new TypeReference<List<Map<String, Object>>>(){};

    public static Builder getInstance() {
        return new Builder();
    }

    public ExcelExportTemplate writeData(List<Object> dataList) {
        if (CollUtil.isEmpty(dataList) || !this.exportDataStrategy.canWrite()) {
            logger.info("dataList is empty or cannot write");
            return this;
        }
        this.costTime.getConvertData().start();
        List<List<Object>> toWriteDataList = this.convertData(dataList);
        this.costTime.getConvertData().stop();
        this.costTime.getWriteData().start();
        try {
            this.exportDataStrategy.writeData(toWriteDataList);
        }
        catch (Exception e) {
            logger.error("\u5199\u5165excel\u5bfc\u51fa\u6570\u636e\u5f02\u5e38\uff1a", (Throwable)e);
            throw e;
        }
        this.costTime.getWriteData().stop();
        return this;
    }

    public void export() {
        this.exportFinish((OutputStream)null);
    }

    public byte[] exportToBytes() {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        this.exportFinish(outputStream);
        return outputStream.toByteArray();
    }

    public void exportToStream(OutputStream outputStream) {
        this.exportFinish(outputStream);
    }

    public void export(HttpServletResponse response) {
        if (response == null || response.isCommitted()) {
            throw new BusinessException("\u54cd\u5e94\u5df2\u5173\u95ed");
        }
        String contentDisposition = ContentDisposition.builder((String)"attachment").filename(this.exportContextParam.getFileName(), StandardCharsets.UTF_8).build().toString();
        response.setHeader("Content-Disposition", contentDisposition);
        response.setCharacterEncoding(StandardCharsets.UTF_8.name());
        response.setContentType(MimeTypeConstant.XLSX.toString());
        this.exportFinish((File file) -> {
            response.setContentLength((int)file.length());
            try (FileInputStream inputStream = new FileInputStream((File)file);){
                StreamUtils.copy((InputStream)inputStream, (OutputStream)response.getOutputStream());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }

    private ExcelExportTemplate() {
        this.startTime = Instant.now();
        this.exportContextParam = new ExportContextParam();
    }

    private void initialize() {
        logger.info("exporter start prepare");
        this.costTime = ExportCostTime.getInstance();
        this.costTime.getPrepare().start();
        this.costTime.getGetTmpl().start();
        this.obtainTmpl();
        this.costTime.getGetTmpl().start();
        this.generateExportFileName();
        this.obtainExportFields();
        this.checkParams();
        this.initExportStrategy();
        this.costTime.getPrepare().stop();
        logger.info("exporter is ready");
    }

    private void checkParams() {
        if (CollUtil.isEmpty(this.exportContextParam.getFieldList())) {
            throw new BusinessException("\u672a\u83b7\u53d6\u5230\u9700\u8981\u5bfc\u51fa\u7684\u5b57\u6bb5");
        }
        if (this.exportContextParam.getTmplDTO() == null || CharSequenceUtil.isBlank((CharSequence)this.exportContextParam.getTmplDTO().getExportSheetStrategy())) {
            throw new RuntimeException("\u5bfc\u51fa\u6a21\u677f\u4fe1\u606f\u5f02\u5e38");
        }
    }

    private void obtainExportFields() {
        ArrayList<String> fieldList = new ArrayList<String>(64);
        ArrayList<String> titleList = new ArrayList<String>(64);
        if (CollUtil.isNotEmpty(this.columnList)) {
            for (ExportColumnParam exportColumnParam : this.columnList) {
                fieldList.add(exportColumnParam.getField());
                titleList.add(exportColumnParam.getTitle());
            }
        } else if (this.exportContextParam.getTmplDTO() != null) {
            fieldList.addAll(this.exportContextParam.getTmplDTO().getAttributeFields());
            titleList.addAll(this.exportContextParam.getTmplDTO().getAttributeTitles());
        }
        if (CollUtil.isNotEmpty(this.extensionColumnList)) {
            for (ExportColumnParam exportColumnParam : this.extensionColumnList) {
                fieldList.add(exportColumnParam.getField());
                titleList.add(exportColumnParam.getTitle());
            }
        }
        this.exportContextParam.setFieldFromTmpl(CollUtil.isNotEmpty(this.columnList) || CollUtil.isNotEmpty(this.extensionColumnList));
        this.exportContextParam.setFieldList(fieldList);
        this.exportContextParam.setTitleList(titleList);
    }

    private void initExportStrategy() {
        SheetLimitStrategy strategy = SheetLimitStrategy.valueOf(this.exportContextParam.getTmplDTO().getExportSheetStrategy());
        switch (strategy) {
            case IGNORE: {
                this.exportDataStrategy = new IgnoreExportDataStrategy(this.exportContextParam);
                break;
            }
            case NEW_SHEET: {
                this.exportDataStrategy = new NewSheetExportDataStrategy(this.exportContextParam);
                break;
            }
            case NEW_FILE: {
                this.exportDataStrategy = new NewFileExportDataStrategy(this.exportContextParam);
                break;
            }
            default: {
                throw new BusinessException("\u6682\u4e0d\u652f\u6301\u7684\u7b56\u7565\uff1a" + strategy);
            }
        }
        this.exportDataStrategy.initialize();
    }

    private void obtainTmpl() {
        String tmplCode = this.exportContextParam.getTmplCode();
        SysTmplDTO tmplDTO = null;
        byte[] tmplFile = null;
        if (StringUtils.hasText((String)tmplCode)) {
            logger.info("starting to get tmpl: {}", (Object)tmplCode);
            try {
                tmplDTO = this.storable.getTmpl(tmplCode);
                tmplFile = this.storable.getTmplFile(tmplCode);
                logger.info("get tmpl finish: {}", (Object)tmplCode);
            }
            catch (Exception e) {
                throw new BusinessException("\u83b7\u53d6\u6a21\u677f\u4fe1\u606f\u5f02\u5e38\uff1a", (Throwable)e);
            }
            if (tmplDTO == null && !this.allowTmplAbsent) {
                throw new BusinessException("\u6a21\u677f\u4e0d\u5b58\u5728\u6216\u672a\u542f\u7528\uff1a" + tmplCode);
            }
        }
        if (tmplDTO == null) {
            logger.info("starting to create default tmpl: {}", (Object)tmplCode);
            tmplDTO = this.createDefaultExportTmplDTO(tmplCode);
        }
        this.exportContextParam.setTmplDTO(tmplDTO);
        this.exportContextParam.setTmplFile(tmplFile);
    }

    private void generateExportFileName() {
        if (StringUtils.hasText((String)this.exportContextParam.getFileName())) {
            return;
        }
        ObjUtil.ifBlank((String)this.exportContextParam.getTmplDTO().getName(), DatetimeUtil::currentTimeLong, f -> this.exportContextParam.setFileName(f + ".xlsx"));
    }

    private List<List<Object>> convertData(List<Object> dataList) {
        if (this.dataType == null) {
            for (Object data2 : dataList) {
                if (data2 == null) continue;
                this.dataType = data2.getClass();
                break;
            }
        }
        return ((List)this.objectMapper.convertValue(dataList, this.dataTypeReference)).stream().filter(Objects::nonNull).map(data -> this.exportContextParam.getFieldList().stream().map(field -> this.normalizeExcelValue((Map<String, Object>)data, (String)field, this.dataType)).collect(Collectors.toList())).collect(Collectors.toList());
    }

    private Object normalizeExcelValue(Map<String, Object> data, String field, Class<?> dataType) {
        Object extensionInfo;
        Object value = data.get(field);
        if (value == null && field.startsWith("extension.") && (extensionInfo = data.get("extensionInfo")) instanceof Map) {
            value = ((Map)extensionInfo).get(field.substring("extension.".length()));
        }
        return ExcelUtil.formatExportedValue(value, field, dataType);
    }

    private void exportFinish(OutputStream outputStream) {
        this.exportFinish((File file) -> {
            if (outputStream != null) {
                try (FileInputStream inputStream = new FileInputStream((File)file);){
                    StreamUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
                }
                catch (Exception e) {
                    logger.error("\u5bfc\u51fa\u7ed3\u675f\u540e\uff0c\u54cd\u5e94\u7ed3\u679c\u5f02\u5e38\uff1a", (Throwable)e);
                }
            }
        });
    }

    private void exportFinish(Consumer<File> excelFileConsumer) {
        this.finishTime = Instant.now();
        logger.info("export finish, cost: {}s", (Object)Duration.between(this.startTime, this.finishTime).getSeconds());
        File file = this.exportDataStrategy.exportToFile();
        if (excelFileConsumer != null) {
            try {
                excelFileConsumer.accept(file);
            }
            catch (Exception e) {
                logger.error("\u5bfc\u51fa\u7ed3\u675f\u540e\uff0c\u54cd\u5e94\u7ed3\u679c\u5f02\u5e38\uff1a", (Throwable)e);
            }
        }
    }

    private SysTmplDTO createDefaultExportTmplDTO(String tmplCode) {
        SysTmplDTO tmplDTO = new SysTmplDTO();
        tmplDTO.setName("\u9ed8\u8ba4\u6a21\u677f");
        tmplDTO.setCode(tmplCode);
        tmplDTO.setFileCode(null);
        tmplDTO.setExport(true);
        tmplDTO.setHeadRow(2);
        tmplDTO.setFieldTypeRow(2);
        tmplDTO.setEnabled(true);
        tmplDTO.setDataLimitPer(-1);
        tmplDTO.setAsyncThreshold(20);
        tmplDTO.setConcurrentLimit(50);
        tmplDTO.setAttributes(null);
        tmplDTO.setAttributeTitles(null);
        tmplDTO.setAttributeFields(null);
        tmplDTO.setExportSheetLimit(1000000);
        tmplDTO.setExportSheetStrategy(SheetLimitStrategy.NEW_SHEET.name());
        return tmplDTO;
    }

    public static class Builder {
        private String tmplCode;
        private boolean allowTmplAbsent = true;
        private AbstractExportQueryParam exportQueryParam;
        private boolean exportField;
        private TmplRecordStorable storable;
        private boolean debug;

        private Builder() {
        }

        public Builder withTmplCode(String tmplCode) {
            this.tmplCode = tmplCode;
            return this;
        }

        public Builder withAllowTmplAbsent(boolean allowTmplAbsent) {
            this.allowTmplAbsent = allowTmplAbsent;
            return this;
        }

        public Builder withExportQueryParam(AbstractExportQueryParam exportQueryParam) {
            this.exportQueryParam = exportQueryParam;
            return this;
        }

        public Builder withExportField(boolean exportField) {
            this.exportField = exportField;
            return this;
        }

        public Builder withStorable(TmplRecordStorable storable) {
            this.storable = storable;
            return this;
        }

        public Builder withDebug(boolean debug) {
            this.debug = debug;
            return this;
        }

        public ExcelExportTemplate build() {
            ExcelExportTemplate template = new ExcelExportTemplate();
            template.exportContextParam.setTmplCode(this.tmplCode);
            template.allowTmplAbsent = this.allowTmplAbsent;
            this.fillTemplateParamsByExportQueryParam(template);
            template.exportContextParam.setExportField(this.exportField);
            this.fillTemplateParamsByStorage(template);
            template.initialize();
            return template;
        }

        private void fillTemplateParamsByStorage(ExcelExportTemplate template) {
            if (this.storable != null) {
                template.storable = this.storable;
                return;
            }
            if (!SpringContextHolder.initialized()) {
                template.storable = new LogTmplRecordStorage();
                return;
            }
            ExcelProperties props = (ExcelProperties)SpringContextHolder.getObjectProvider(ExcelProperties.class).getIfAvailable();
            Assert.notNull((Object)props, (String)"\u83b7\u53d6Excel\u5bfc\u51fa\u914d\u7f6e\u5931\u8d25");
            for (TmplRecordStorable tmplRecordStorable : SpringContextHolder.getObjectProvider(TmplRecordStorable.class)) {
                if (!tmplRecordStorable.support(props.getStorageType())) continue;
                template.storable = tmplRecordStorable;
                return;
            }
            throw new BusinessException("\u672a\u83b7\u53d6\u5230\u6709\u6548\u7684\u6a21\u677f\u8bb0\u5f55\u5b58\u50a8\u5b9e\u73b0");
        }

        private void fillTemplateParamsByExportQueryParam(ExcelExportTemplate template) {
            if (this.exportQueryParam == null) {
                HttpServletRequest request = HttpServletUtil.currentRequest();
                if (request == null) {
                    return;
                }
                Object requestBody = request.getAttribute("cloudt-requestBody");
                if (!(requestBody instanceof AbstractExportQueryParam)) {
                    return;
                }
                this.exportQueryParam = (AbstractExportQueryParam)((Object)requestBody);
            }
            template.exportContextParam.setFileName(this.exportQueryParam.getFileName());
            if (CollUtil.isEmpty(this.exportQueryParam.getExportColumn())) {
                return;
            }
            template.columnList = this.exportQueryParam.getExportColumn().stream().map(t -> new ExportColumnParam(t.getField(), t.getTitle())).collect(Collectors.toList());
            if (CollUtil.isNotEmpty(this.exportQueryParam.getExtensionColumn())) {
                template.extensionColumnList = this.exportQueryParam.getExtensionColumn().stream().map(t -> new ExportColumnParam(t.getField(), t.getTitle())).collect(Collectors.toList());
            }
        }
    }
}

