/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.excel.config.tmpl.export.strategy;

import com.alibaba.excel.exception.ExcelGenerateException;
import com.elitescloud.boot.common.param.AbstractOrderQueryParam;
import com.elitescloud.boot.excel.common.param.SheetLimitStrategy;
import com.elitescloud.boot.excel.config.tmpl.export.ExportStrategyParam;
import com.elitescloud.boot.excel.config.tmpl.export.SystemTmplDataSupport;
import com.elitescloud.boot.excel.config.tmpl.export.strategy.ExportStrategy;
import com.elitescloud.boot.excel.config.tmpl.export.strategy.IgnoreExportStrategy;
import com.elitescloud.boot.excel.config.tmpl.export.strategy.NewFileExportStrategy;
import com.elitescloud.boot.excel.config.tmpl.export.strategy.NewSheetExportStrategy;
import com.elitescloud.boot.excel.util.ExcelUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.provider.FileProvider;
import com.elitescloud.boot.util.ExceptionsUtil;
import com.elitescloud.cloudt.system.dto.SysTmplDTO;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class TmplExportStrategyDelegate<R extends Serializable, P extends AbstractOrderQueryParam>
implements ExportStrategy<R, P> {
    private final Map<SheetLimitStrategy, Constructor> strategyMap = new HashMap<SheetLimitStrategy, Constructor>();
    private final FileProvider fileProvider;
    private final SystemTmplDataSupport fsmTmplSupport;
    private final ObjectMapper objectMapper;

    public TmplExportStrategyDelegate(FileProvider fileProvider, SystemTmplDataSupport fsmTmplSupport) {
        this.fileProvider = fileProvider;
        this.fsmTmplSupport = fsmTmplSupport;
        this.objectMapper = ExcelUtil.buildObjectMapper();
        this.init();
    }

    @Override
    public long export(ExportStrategyParam<R, P> param) throws Exception {
        SheetLimitStrategy sheetLimitStrategy = this.obtainSheetStrategy(param.getTmplDTO());
        Constructor strategyClazz = this.strategyMap.get((Object)sheetLimitStrategy);
        Assert.notNull((Object)strategyClazz, (String)"\u6682\u4e0d\u652f\u6301\u7684\u5bfc\u51fa\u7b56\u7565");
        ExportStrategy exportStrategy = null;
        try {
            exportStrategy = (ExportStrategy)strategyClazz.newInstance(this.fileProvider, this.fsmTmplSupport, this.objectMapper);
        }
        catch (Throwable e) {
            throw new IllegalStateException("\u5b9e\u4f8b\u5316\u5bfc\u51fa\u7b56\u7565\u5f02\u5e38", e);
        }
        try {
            return exportStrategy.export(param);
        }
        catch (Exception e) {
            if (ExceptionsUtil.isCausedBy((Throwable)e, (Class[])new Class[]{ExcelGenerateException.class})) {
                throw new BusinessException("\u751f\u6210Excel\u5f02\u5e38\uff0c\u8bf7\u786e\u8ba4\u73af\u5883\u6b63\u5e38", (Throwable)e);
            }
            throw e;
        }
    }

    private SheetLimitStrategy obtainSheetStrategy(SysTmplDTO tmplDTO) {
        if (!StringUtils.hasText((String)tmplDTO.getExportSheetStrategy())) {
            return SheetLimitStrategy.NEW_SHEET;
        }
        return SheetLimitStrategy.valueOf(tmplDTO.getExportSheetStrategy());
    }

    private void init() {
        try {
            Class[] classes = new Class[]{FileProvider.class, SystemTmplDataSupport.class, ObjectMapper.class};
            this.strategyMap.put(SheetLimitStrategy.IGNORE, IgnoreExportStrategy.class.getDeclaredConstructor(classes));
            this.strategyMap.put(SheetLimitStrategy.NEW_SHEET, NewSheetExportStrategy.class.getDeclaredConstructor(classes));
            this.strategyMap.put(SheetLimitStrategy.NEW_FILE, NewFileExportStrategy.class.getDeclaredConstructor(classes));
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("\u5bfc\u51fa\u7b56\u7565\u5b9e\u73b0\u7c7b\u7f3a\u5c11\u6307\u5b9a\u7684\u6784\u9020\u65b9\u6cd5", e);
        }
    }
}

