/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.excel.support.export.strategy;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.elitescloud.boot.excel.support.export.ExportContextParam;
import com.elitescloud.boot.excel.support.export.strategy.BaseExportDataStrategy;
import com.elitescloud.boot.excel.util.ExcelUtil;
import com.elitescloud.boot.util.FileUtil;
import java.io.File;
import java.util.List;

public class NewSheetExportDataStrategy
extends BaseExportDataStrategy {
    private File excelFile;
    private ExcelWriter excelWriter;
    private int sheetIndex = 0;
    private WriteSheet sheet;
    private int dataRowCount = 0;

    public NewSheetExportDataStrategy(ExportContextParam contextParam) {
        super(contextParam);
    }

    @Override
    public void initialize() {
        super.initialize();
        this.excelFile = FileUtil.createTempFile((String)this.contextParam.getFileName(), (String[])new String[0]);
        this.excelWriter = ExcelUtil.normalizeExcelWriter(EasyExcel.write((File)this.excelFile)).build();
    }

    @Override
    void doWrite(List<List<Object>> dataList) {
        if (this.sheet == null) {
            this.sheet = super.createSheet(this.sheetIndex);
        }
        if (this.dataRowCount >= this.sheetDataLimit) {
            ++this.sheetIndex;
            this.sheet = super.createSheet(this.sheetIndex);
            this.dataRowCount = 0;
        }
        if (this.dataRowCount + dataList.size() > this.sheetDataLimit) {
            int starIndex = 0;
            int endIndex = this.sheetDataLimit - this.dataRowCount;
            List<List<Object>> tempDataList = dataList.subList(starIndex, endIndex);
            while (endIndex < dataList.size()) {
                this.excelWriter.write(tempDataList, this.sheet);
                ++this.sheetIndex;
                this.sheet = super.createSheet(this.sheetIndex);
                this.dataRowCount = 0;
                starIndex = endIndex;
                endIndex = starIndex + Math.min(dataList.size() - endIndex, this.sheetDataLimit);
                tempDataList = dataList.subList(starIndex, endIndex);
                this.dataRowCount += tempDataList.size();
            }
            ++this.sheetIndex;
            this.sheet = super.createSheet(this.sheetIndex);
        }
    }
}

