/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.excel.config.tmpl.converter;

import com.alibaba.excel.enums.CellDataTypeEnum;
import com.alibaba.excel.metadata.CellData;
import com.alibaba.excel.metadata.GlobalConfiguration;
import com.alibaba.excel.metadata.property.ExcelContentProperty;
import com.elitescloud.boot.excel.common.support.CustomConverter;
import com.elitescloud.boot.util.DatetimeUtil;
import java.time.LocalDate;

class LocalDateConverter
implements CustomConverter<LocalDate> {
    LocalDateConverter() {
    }

    public Class<LocalDate> supportJavaTypeKey() {
        return LocalDate.class;
    }

    public CellDataTypeEnum supportExcelTypeKey() {
        return CellDataTypeEnum.STRING;
    }

    public LocalDate convertToJavaData(CellData cellData, ExcelContentProperty contentProperty, GlobalConfiguration globalConfiguration) throws Exception {
        String strValue = cellData.getDataFormatString();
        return DatetimeUtil.parseLocalDate((String)strValue);
    }

    public CellData<String> convertToExcelData(LocalDate value, ExcelContentProperty contentProperty, GlobalConfiguration globalConfiguration) throws Exception {
        String strValue = value == null ? "" : DatetimeUtil.toStr((LocalDate)value);
        return new CellData(strValue);
    }
}

