/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.excel.support;

import cn.hutool.core.collection.CollUtil;
import com.elitescloud.boot.common.CloudtBootLoggerFactory;
import com.elitescloud.boot.common.param.FileByteVO;
import com.elitescloud.boot.excel.config.tmpl.export.SystemTmplDataSupport;
import com.elitescloud.boot.excel.util.ExcelUtil;
import com.elitescloud.boot.util.ArrayUtil;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.dto.SysTmplDTO;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.ss.usermodel.Sheet;
import org.slf4j.Logger;

public class TmplDataExportWrapper {
    private static final Logger logger = CloudtBootLoggerFactory.EXCEL_EXPORT.getLogger(TmplDataExportWrapper.class);
    private final SysTmplDTO tmplDTO;
    private final Map<String, Object> queryParams;
    private Map<String, String> extensionField;
    private boolean fieldFromFront;
    private Sheet tmplSheet;

    public TmplDataExportWrapper(SysTmplDTO tmplDTO, Map<String, Object> queryParams, SystemTmplDataSupport tmplDataSupport) {
        this.tmplDTO = tmplDTO;
        this.queryParams = queryParams;
        this.analyze(tmplDataSupport);
    }

    public SysTmplDTO getTmplDTO() {
        return this.tmplDTO;
    }

    public Map<String, Object> getQueryParams() {
        return this.queryParams;
    }

    public Map<String, String> getExtensionField() {
        return this.extensionField;
    }

    public boolean isFieldFromFront() {
        return this.fieldFromFront;
    }

    public Sheet getTmplSheet() {
        return this.tmplSheet;
    }

    private void analyze(SystemTmplDataSupport tmplDataSupport) {
        if (CollUtil.isEmpty(this.queryParams)) {
            return;
        }
        this.dealExportColumn();
        this.dealExtensionColumn();
        this.queryTmplSheet(tmplDataSupport);
    }

    private void dealExtensionColumn() {
        Object extensionColumn = this.queryParams.get("extensionColumn");
        if (extensionColumn == null) {
            this.extensionField = Collections.emptyMap();
            return;
        }
        if (!(extensionColumn instanceof Collection)) {
            throw new IllegalArgumentException("\u6269\u5c55\u5b57\u6bb5\u8bbe\u7f6e\u6709\u8bef");
        }
        this.extensionField = new LinkedHashMap<String, String>(((Collection)extensionColumn).size());
        ArrayList<String> fields = new ArrayList<String>(this.tmplDTO.getAttributeFields());
        ArrayList<String> titles = new ArrayList<String>(this.tmplDTO.getAttributeTitles());
        Object field = null;
        Object title = null;
        String fieldName = null;
        for (Object obj : (Collection)extensionColumn) {
            if (!(obj instanceof Map)) {
                throw new IllegalArgumentException("\u6269\u5c55\u5b57\u6bb5\u7684\u5217\u8bbe\u7f6e\u6709\u8bef");
            }
            Map columnParam = (Map)obj;
            field = columnParam.get("field");
            title = columnParam.get("title");
            if (field == null) continue;
            if (!(field instanceof String)) {
                throw new IllegalArgumentException("\u6269\u5c55\u5217\u8bbe\u7f6e\u6709\u8bef");
            }
            fieldName = "extension." + String.valueOf(field);
            this.extensionField.put(fieldName, title == null ? "" : title.toString());
            fields.add(fieldName);
            titles.add(title == null ? "" : title.toString());
        }
        this.tmplDTO.setAttributeFields(fields);
        this.tmplDTO.setAttributeTitles(titles);
        this.tmplDTO.setAttributes(List.of(titles, fields));
    }

    private void dealExportColumn() {
        Object exportColumn = this.queryParams.get("exportColumn");
        if (exportColumn == null) {
            return;
        }
        if (!(exportColumn instanceof Collection)) {
            throw new IllegalArgumentException("\u5bfc\u51fa\u5217\u8bbe\u7f6e\u6709\u8bef");
        }
        ArrayList<String> fieldList = new ArrayList<String>();
        ArrayList<String> titleList = new ArrayList<String>();
        Object field = null;
        Object title = null;
        for (Object obj : (Collection)exportColumn) {
            if (!(obj instanceof Map)) {
                throw new IllegalArgumentException("\u5bfc\u51fa\u5217\u8bbe\u7f6e\u6709\u8bef");
            }
            Map columnParam = (Map)obj;
            field = columnParam.get("field");
            title = columnParam.get("title");
            if (field == null) continue;
            if (!(field instanceof String)) {
                throw new IllegalArgumentException("\u5bfc\u51fa\u5217\u8bbe\u7f6e\u6709\u8bef");
            }
            fieldList.add(field);
            titleList.add(title == null ? "" : title.toString());
        }
        this.tmplDTO.setAttributeFields(fieldList);
        this.tmplDTO.setAttributeTitles(titleList);
        this.tmplDTO.setAttributes(List.of(titleList, fieldList));
        this.tmplDTO.setHeadRow(2);
        this.tmplDTO.setFieldTypeRow(2);
        this.fieldFromFront = true;
    }

    private void queryTmplSheet(SystemTmplDataSupport tmplDataSupport) {
        if (this.isFieldFromFront()) {
            return;
        }
        ApiResult<FileByteVO> downloadResult = tmplDataSupport.getTmplFileByCode(this.tmplDTO.getCode());
        if (downloadResult.getData() == null) {
            logger.error("\u83b7\u53d6\u6a21\u677f\u6587\u4ef6\u5931\u8d25\uff1a{}, {}", (Object)this.tmplDTO.getCode(), (Object)downloadResult.getMsg());
            return;
        }
        if (ArrayUtil.isEmpty((byte[])((FileByteVO)downloadResult.getData()).getBytes())) {
            return;
        }
        this.tmplSheet = ExcelUtil.getReader((InputStream)new ByteArrayInputStream(((FileByteVO)downloadResult.getData()).getBytes()), (int)0).getSheet();
    }
}

