/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.excel.support.export;

import cn.hutool.core.collection.CollUtil;
import com.elitescloud.boot.excel.support.export.ExcelDataSplitListener;
import java.util.List;

public class ExcelDataSplitter<T> {
    private final int sheetDataLimit;
    private final ExcelDataSplitListener<T> listener;
    private boolean initialized;
    private boolean finished;
    private int sheetIndex;
    private int sheetSize;

    public ExcelDataSplitter(int sheetDataLimit, ExcelDataSplitListener<T> listener) {
        this.sheetDataLimit = sheetDataLimit;
        this.listener = listener;
        this.initialized = false;
        this.sheetIndex = -1;
        this.sheetSize = 0;
    }

    public void accept(List<T> dataList) {
        if (CollUtil.isEmpty(dataList) || this.finished) {
            return;
        }
        if (!this.initialized) {
            this.listener.onInitialize();
            this.initialized = true;
        }
        if (this.sheetSize == 0) {
            this.newSheet();
        }
        this.splitData(dataList);
    }

    private void splitData(List<T> dataList) {
        if (CollUtil.isEmpty(dataList)) {
            return;
        }
        if (this.sheetSize == this.sheetDataLimit) {
            boolean continueSplit = this.listener.onSheetFinish(this.sheetIndex);
            if (!continueSplit) {
                this.finished = true;
                return;
            }
            this.newSheet();
        }
        if (this.sheetSize + dataList.size() <= this.sheetDataLimit) {
            this.acceptData(dataList);
            return;
        }
        int endIndex = this.sheetDataLimit - this.sheetSize;
        this.acceptData(dataList.subList(0, endIndex));
        this.splitData(dataList.subList(endIndex, dataList.size()));
    }

    private void acceptData(List<T> dataList) {
        this.listener.onSplit(this.sheetIndex, dataList);
        this.sheetSize += dataList.size();
    }

    private void newSheet() {
        ++this.sheetIndex;
        this.listener.onNewSheet(this.sheetIndex);
        this.sheetSize = 0;
    }
}

