/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.excel.config.tmpl;

import cn.hutool.core.collection.CollUtil;
import com.elitescloud.boot.common.CloudtBootLoggerFactory;
import com.elitescloud.boot.excel.common.DataImport;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.util.ClassUtil;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.springframework.aop.framework.AopProxyUtils;

public class DataImportServiceFactory {
    private static final Logger logger = CloudtBootLoggerFactory.EXCEL_IMPORT.getLogger(DataImportServiceFactory.class);
    private final Map<String, ServiceMetaData> dataImportMap = new HashMap<String, ServiceMetaData>(64);

    public DataImportServiceFactory(List<DataImport<?>> dataImportList) {
        this.init(dataImportList);
    }

    public boolean isSupport(String tmplCode) {
        return this.dataImportMap.containsKey(tmplCode);
    }

    public ServiceMetaData getDataImportService(String tmplCode) {
        return this.dataImportMap.get(tmplCode);
    }

    private void init(List<DataImport<?>> dataImportList) {
        if (CollUtil.isEmpty(dataImportList)) {
            return;
        }
        for (DataImport<?> dataImport : dataImportList) {
            if (!this.dataImportMap.containsKey(dataImport.getTmplCode())) continue;
            throw new IllegalStateException("\u5b58\u5728\u91cd\u590d\u7684\u6570\u636e\u5bfc\u5165\u670d\u52a1\uff1a" + dataImport.getTmplCode());
        }
        CompletableFuture.runAsync(() -> {
            for (DataImport dataImport : dataImportList) {
                try {
                    this.dataImportMap.put(dataImport.getTmplCode(), new ServiceMetaData(dataImport));
                }
                catch (Exception e) {
                    logger.error("\u52a0\u8f7d\u6587\u4ef6\u5bfc\u5165\u670d\u52a1\u5f02\u5e38\uff1a{}, {}", (Object)dataImport.getTmplCode(), (Object)ClassUtil.getTargetClass((Object)dataImport).getName());
                    throw e;
                }
            }
        }).whenComplete((r, e) -> {
            if (e != null) {
                logger.error("\u521d\u59cb\u5316\u6570\u636e\u5bfc\u5165\u670d\u52a1\u5f02\u5e38\uff1a", e);
                return;
            }
            logger.info("initialized DataImportService\uff1a{}", (Object)String.join((CharSequence)",", this.dataImportMap.keySet()));
        });
    }

    public static class ServiceMetaData {
        private final String tmplCode;
        private final Object dataImport;
        private final Class<?> dataType;
        private final Method importMethod;
        private final Method beforeImportMethod;
        private final Method afterImportMethod;
        private final Method failMsgMethod;
        private final boolean respSuccessData;
        private final boolean respFailData;
        private final boolean respFailMsg;

        public <T extends DataImport<R>, R> ServiceMetaData(T dataImport) {
            this.tmplCode = dataImport.getTmplCode();
            this.dataImport = dataImport;
            Class beanClass = AopProxyUtils.ultimateTargetClass(dataImport);
            this.dataType = (Class)((ParameterizedType)beanClass.getGenericInterfaces()[0]).getActualTypeArguments()[0];
            if (!Serializable.class.isAssignableFrom(this.dataType)) {
                logger.error("\u53c2\u6570\u7c7b\u578b\uff1a{}\u672a\u5b9e\u73b0\u5e8f\u5217\u5316\u63a5\u53e3Serializable", (Object)this.dataType.getName());
            }
            try {
                this.importMethod = dataImport.getClass().getMethod("executeImport", List.class, Integer.TYPE);
            }
            catch (NoSuchMethodException e) {
                throw new IllegalStateException("\u672a\u83b7\u53d6\u5230\u5bfc\u5165\u65b9\u6cd5", e);
            }
            try {
                this.beforeImportMethod = dataImport.getClass().getMethod("beforeImport", List.class);
            }
            catch (NoSuchMethodException e) {
                throw new IllegalStateException("\u672a\u83b7\u53d6\u5230\u9884\u5bfc\u5165\u5904\u7406\u65b9\u6cd5", e);
            }
            try {
                this.afterImportMethod = dataImport.getClass().getMethod("afterImport", Boolean.TYPE);
            }
            catch (NoSuchMethodException e) {
                throw new IllegalStateException("\u672a\u83b7\u53d6\u5230\u540e\u7f6e\u5bfc\u5165\u5904\u7406\u65b9\u6cd5", e);
            }
            try {
                this.failMsgMethod = dataImport.getClass().getMethod("failMsg", new Class[0]);
            }
            catch (NoSuchMethodException e) {
                throw new IllegalStateException("\u672a\u83b7\u53d6\u5230\u81ea\u5b9a\u4e49\u5931\u8d25\u4fe1\u606f\u7684\u5904\u7406\u65b9\u6cd5", e);
            }
            this.respSuccessData = dataImport.respSuccessData();
            this.respFailData = dataImport.respFailData();
            this.respFailMsg = dataImport.respFailMsg();
        }

        public String applyGetTmplCode() {
            return this.tmplCode;
        }

        public Class<?> applyGetDataType() {
            return this.dataType;
        }

        public int applyGetStepSize() {
            Integer stepSize = ((DataImport)this.dataImport).stepSize();
            if (stepSize == null || stepSize < 1) {
                return 10;
            }
            return stepSize;
        }

        public Set<Integer> applyGetSheetNos() {
            return ((DataImport)this.dataImport).sheetNoList();
        }

        public List<String> applyImport(List<? extends Serializable> dataList, int startRowIndex) {
            try {
                return (List)this.importMethod.invoke(this.dataImport, dataList, startRowIndex);
            }
            catch (Throwable e) {
                throw new BusinessException("\u5bfc\u5165\u6570\u636e\u5f02\u5e38", e);
            }
        }

        public void applyBeforeImport(List<? extends Serializable> dataList) {
            try {
                this.beforeImportMethod.invoke(this.dataImport, dataList);
            }
            catch (Throwable e) {
                throw new BusinessException("\u5bfc\u5165\u5931\u8d25\uff0c" + e.getMessage(), e);
            }
        }

        public void applyAfterImport(boolean sync) {
            try {
                this.afterImportMethod.invoke(this.dataImport, sync);
            }
            catch (Throwable e) {
                logger.error("\u5904\u7406\u5bfc\u5165\u540e\u7f6e\u5f02\u5e38\uff1a", e);
            }
        }

        public String applyMsgFail() {
            try {
                return (String)this.failMsgMethod.invoke(this.dataImport, new Object[0]);
            }
            catch (Throwable e) {
                logger.error("\u83b7\u53d6\u81ea\u5b9a\u4e49\u5931\u8d25\u4fe1\u606f\u5f02\u5e38\uff1a", e);
                return null;
            }
        }

        public boolean isRespSuccessData() {
            return this.respSuccessData;
        }

        public boolean isRespFailData() {
            return this.respFailData;
        }

        public boolean isRespFailMsg() {
            return this.respFailMsg;
        }
    }
}

