package com.elitescloud.boot.jdbc.common;

import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.lang.NonNull;

import javax.validation.constraints.NotNull;
import java.beans.PropertyDescriptor;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2024/7/1
 */
public class BeanPropertyRowMapperFactory {

    private static final Map<Class<?>, BeanPropertyRowMapper<?>> MAPPER_MAP = new HashMap<>();

    public static <T> BeanPropertyRowMapper<T> get(@NotNull Class<T> clazz) {
        BeanPropertyRowMapper<T> rowMapper = (BeanPropertyRowMapper<T>) MAPPER_MAP.get(clazz);
        if (rowMapper != null) {
            return rowMapper;
        }

        rowMapper = new BeanPropertyMapperWrapper<>(clazz);
        MAPPER_MAP.put(clazz, rowMapper);

        return rowMapper;
    }

    private static class BeanPropertyMapperWrapper<T> extends BeanPropertyRowMapper<T> {

        public BeanPropertyMapperWrapper(Class<T> mappedClass) {
            super(mappedClass);
        }

        @Override
        protected void initialize(@NonNull Class<T> mappedClass) {
            super.initialize(mappedClass);
//            for (PropertyDescriptor pd : BeanUtils.getPropertyDescriptors(mappedClass)) {
//                if (pd.getWriteMethod() == null) {
//                    continue;
//                }
//                if (!ClassUtil.isSimpleValueType(pd.getPropertyType())) {
//                    this.suppressProperty(pd.getName());
//                }
//            }
        }

        @Override
        protected Object getColumnValue(@NonNull ResultSet rs, int index, @NonNull PropertyDescriptor pd) throws SQLException {
            if (Collection.class.isAssignableFrom(pd.getPropertyType())) {
                return rs.getObject(index);
            }
            return super.getColumnValue(rs, index, pd);
        }

        @Override
        protected Object getColumnValue(@NonNull ResultSet rs, int index, @NonNull Class<?> paramType) throws SQLException {
            if (Collection.class.isAssignableFrom(paramType)) {
                return rs.getObject(index);
            }
            return super.getColumnValue(rs, index, paramType);
        }
    }
}
