/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.jdbc.common;

import java.beans.PropertyDescriptor;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.validation.constraints.NotNull;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.lang.NonNull;

public class BeanPropertyRowMapperFactory {
    private static final Map<Class<?>, BeanPropertyRowMapper<?>> MAPPER_MAP = new HashMap();

    public static <T> BeanPropertyRowMapper<T> get(@NotNull Class<T> clazz) {
        BeanPropertyRowMapper<?> rowMapper = MAPPER_MAP.get(clazz);
        if (rowMapper != null) {
            return rowMapper;
        }
        rowMapper = new BeanPropertyMapperWrapper(clazz);
        MAPPER_MAP.put(clazz, rowMapper);
        return rowMapper;
    }

    private static class BeanPropertyMapperWrapper<T>
    extends BeanPropertyRowMapper<T> {
        public BeanPropertyMapperWrapper(Class<T> mappedClass) {
            super(mappedClass);
        }

        protected void initialize(@NonNull Class<T> mappedClass) {
            super.initialize(mappedClass);
        }

        protected Object getColumnValue(@NonNull ResultSet rs, int index, @NonNull PropertyDescriptor pd) throws SQLException {
            if (Collection.class.isAssignableFrom(pd.getPropertyType())) {
                return rs.getObject(index);
            }
            return super.getColumnValue(rs, index, pd);
        }

        protected Object getColumnValue(@NonNull ResultSet rs, int index, @NonNull Class<?> paramType) throws SQLException {
            if (Collection.class.isAssignableFrom(paramType)) {
                return rs.getObject(index);
            }
            return super.getColumnValue(rs, index, paramType);
        }
    }
}

