package com.elitescloud.boot.jpa;

import com.elitescloud.boot.jpa.config.HibernateConfig;
import com.elitescloud.boot.jpa.config.auditing.AuditConfig;
import com.elitescloud.boot.jpa.config.entity.EntityConfig;
import org.springframework.boot.autoconfigure.domain.EntityScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;

/**
 * JPA自动化配置.
 *
 * @author Kaiser（wang shao）
 * @date 3/13/2023
 */
@Configuration(proxyBeanMethods = false)
@Import({
        HibernateConfig.class, EntityConfig.class, AuditConfig.class
})
@EntityScan(basePackages = {"com.elitescloud", "com.elitesland"})
@EnableJpaRepositories(basePackages = {"com.elitescloud", "com.elitesland"})
public class CloudtJpaAutoConfiguration {
}
