/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.jpa.common;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.text.CharSequenceUtil;
import com.blazebit.persistence.CriteriaBuilderFactory;
import com.blazebit.persistence.PagedList;
import com.blazebit.persistence.querydsl.BlazeJPAQuery;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.base.QBaseModel;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Order;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.SubQueryExpression;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.ComparableExpression;
import com.querydsl.core.types.dsl.EntityPathBase;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.core.types.dsl.NumberExpression;
import com.querydsl.core.types.dsl.NumberPath;
import com.querydsl.core.types.dsl.PathBuilder;
import com.querydsl.core.types.dsl.SimpleExpression;
import com.querydsl.core.types.dsl.StringExpression;
import com.querydsl.core.types.dsl.TemporalExpression;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import javax.persistence.EntityManager;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Sort;
import org.springframework.util.StringUtils;

public abstract class BaseRepoProc<T extends Serializable> {
    private static final Logger log = LogManager.getLogger(BaseRepoProc.class);
    protected JPAQueryFactory jpaQueryFactory;
    protected EntityManager entityManager;
    protected CriteriaBuilderFactory criteriaBuilderFactory;
    private final EntityPathBase<T> qModel;
    private PathBuilder<?> pathBuilder;

    protected BaseRepoProc(@NotNull EntityPathBase<T> qModel) {
        this.qModel = qModel;
    }

    public long delete(long id) {
        return this.jpaQueryFactory.delete(this.qModel).where(new Predicate[]{this.getIdPath().eq((Object)id)}).execute();
    }

    public long delete(@NotEmpty Collection<Long> ids) {
        return this.jpaQueryFactory.delete(this.qModel).where(new Predicate[]{this.getIdPath().in(ids)}).execute();
    }

    protected <P, Q extends Path<P>> long deleteByValue(@NotNull Q path, P value) {
        return this.jpaQueryFactory.delete(this.qModel).where(new Predicate[]{this.fieldEq(path, value)}).execute();
    }

    protected <P, Q extends Path<P>> long deleteByValue(@NotNull Q path, @NotEmpty Collection<P> values) {
        return this.jpaQueryFactory.delete(this.qModel).where(new Predicate[]{this.fieldIn(path, values)}).execute();
    }

    public long updateDeleteFlag(long id) {
        return this.jpaQueryFactory.update(this.qModel).set(this.getDeleteFlagPath(), (Object)1).where(new Predicate[]{this.getIdPath().eq((Object)id)}).execute();
    }

    public long updateDeleteFlag(long id, int value) {
        return this.jpaQueryFactory.update(this.qModel).set(this.getDeleteFlagPath(), (Object)value).where(new Predicate[]{this.getIdPath().eq((Object)id)}).execute();
    }

    public long updateDeleteFlag(@NotEmpty Collection<Long> ids) {
        return this.jpaQueryFactory.update(this.qModel).set(this.getDeleteFlagPath(), (Object)1).where(new Predicate[]{this.getIdPath().in(ids)}).execute();
    }

    public long updateDeleteFlag(@NotEmpty Collection<Long> ids, int value) {
        return this.jpaQueryFactory.update(this.qModel).set(this.getDeleteFlagPath(), (Object)value).where(new Predicate[]{this.getIdPath().in(ids)}).execute();
    }

    protected <P, Q extends Path<P>> long updateDeleteFlagByValue(@NotNull Q path, P value) {
        return this.jpaQueryFactory.update(this.qModel).set(this.getDeleteFlagPath(), (Object)1).where(new Predicate[]{this.fieldEq(path, value)}).execute();
    }

    protected <P, Q extends Path<P>> long updateDeleteFlagByValue(@NotNull Q path, @NotEmpty Collection<P> values) {
        return this.jpaQueryFactory.update(this.qModel).set(this.getDeleteFlagPath(), (Object)1).where(new Predicate[]{this.fieldIn(path, values)}).execute();
    }

    public long removeDeleteFlag(long id) {
        return this.jpaQueryFactory.update(this.qModel).set(this.getDeleteFlagPath(), (Object)0).where(new Predicate[]{this.getIdPath().eq((Object)id)}).execute();
    }

    public long removeDeleteFlag(@NotEmpty Collection<Long> ids) {
        return this.jpaQueryFactory.update(this.qModel).set(this.getDeleteFlagPath(), (Object)0).where(new Predicate[]{this.getIdPath().in(ids)}).execute();
    }

    protected <P, Q extends Path<P>> long removeDeleteFlagByValue(@NotNull Q path, P value) {
        return this.jpaQueryFactory.update(this.qModel).set(this.getDeleteFlagPath(), (Object)0).where(new Predicate[]{this.fieldEq(path, value)}).execute();
    }

    protected <P, Q extends Path<P>> long removeDeleteFlagByValue(@NotNull Q path, @NotEmpty Collection<P> values) {
        return this.jpaQueryFactory.update(this.qModel).set(this.getDeleteFlagPath(), (Object)0).where(new Predicate[]{this.fieldIn(path, values)}).execute();
    }

    public T get(long id) {
        return (T)((Serializable)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.qModel).from(this.qModel)).where((Predicate)this.getIdPath().eq((Object)id))).limit(1L)).fetchOne());
    }

    public Optional<T> getOptional(long id) {
        return Optional.ofNullable(this.get(id));
    }

    public List<T> get(@NotEmpty Collection<Long> ids) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.qModel).from(this.qModel)).where((Predicate)this.getIdPath().in(ids))).fetch();
    }

    public List<T> get(@NotEmpty Long[] ids) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.qModel).from(this.qModel)).where((Predicate)this.getIdPath().in((Object[])ids))).fetch();
    }

    protected <P, Q extends Path<P>> T getOneByValue(@NotNull Q path, P value) {
        return (T)((Serializable)this.getOneOptionalByValue(path, value).orElse(null));
    }

    protected <P, Q extends Path<P>> Optional<T> getOneOptionalByValue(@NotNull Q path, P value) {
        return Optional.ofNullable((Serializable)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.qModel).from(this.qModel)).where((Predicate)this.fieldEq(path, value))).limit(1L)).fetchOne());
    }

    protected List<T> getList(Predicate predicate) {
        return ((JPAQuery)this.jpaQueryFactory.selectFrom(this.qModel).where(predicate)).fetch();
    }

    protected <P, Q extends Path<P>> List<T> getListByValue(@NotNull Q path, P value) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.qModel).from(this.qModel)).where((Predicate)this.fieldEq(path, value))).fetch();
    }

    protected <P, Q extends Path<P>> List<T> getListByValue(@NotNull Q path, @NotEmpty Collection<P> value) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.qModel).from(this.qModel)).where((Predicate)this.fieldIn(path, value))).fetch();
    }

    public boolean exists(long id) {
        return ((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.getIdPath()).from(this.qModel)).where((Predicate)this.getIdPath().eq((Object)id))).limit(1L)).fetchOne() != null;
    }

    public List<Long> exists(Collection<Long> ids) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.getIdPath()).from(this.qModel)).where((Predicate)this.getIdPath().in(ids))).fetch();
    }

    public <P, Q extends SimpleExpression<P>> List<P> exists(@NotNull Q path, @NotEmpty Collection<P> value) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(path).from(this.qModel)).where((Predicate)path.in(value))).fetch();
    }

    public List<T> all() {
        return this.getList(null);
    }

    public List<T> allForUnDeleted() {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.qModel).from(this.qModel)).where((Predicate)this.getDeleteFlagPath().eq((Object)0))).fetch();
    }

    public List<Long> allId() {
        return ((JPAQuery)this.jpaQueryFactory.select(this.getIdPath()).from(this.qModel)).fetch();
    }

    public List<Long> allIdForUnDeleted() {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.getIdPath()).from(this.qModel)).where((Predicate)this.getDeleteFlagPath().eq((Object)0))).fetch();
    }

    protected <P, Q extends Path<P>> P getValue(@NotNull Q path, long id) {
        return (P)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(path).from(this.qModel)).where((Predicate)this.getIdPath().eq((Object)id))).limit(1L)).fetchOne();
    }

    protected <P, Q extends Path<P>> List<P> getValue(@NotNull Q path, @NotEmpty Collection<Long> ids) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(path).from(this.qModel)).where((Predicate)this.getIdPath().in(ids))).fetch();
    }

    protected <P, Q extends Path<P>, X, Y extends Path<X>> P getValueByValue(@NotNull Q path, @NotNull Y fieldPath, X fieldValue) {
        return (P)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(path).from(this.qModel)).where((Predicate)this.fieldEq(fieldPath, fieldValue))).limit(1L)).fetchOne();
    }

    protected <P, Q extends Path<P>, X, Y extends Path<X>> List<P> getValueByValue(@NotNull Q path, @NotNull Y fieldPath, @NotEmpty Collection<X> fieldValues) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(path).from(this.qModel)).where((Predicate)this.fieldIn(fieldPath, fieldValues))).fetch();
    }

    protected <P, Q extends Path<P>> Long getIdByValue(@NotNull Q path, P value) {
        return this.getIdOptionalByValue(path, value).orElse(null);
    }

    protected <P, Q extends Path<P>> Optional<Long> getIdOptionalByValue(@NotNull Q path, P value) {
        return Optional.ofNullable((Long)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.getIdPath()).from(this.qModel)).where((Predicate)this.fieldEq(path, value))).limit(1L)).fetchOne());
    }

    protected <P, Q extends Path<P>> List<Long> getIdsByValue(@NotNull Q path, P value) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.getIdPath()).from(this.qModel)).where((Predicate)this.fieldEq(path, value))).fetch();
    }

    protected <P, Q extends Path<P>> List<Long> getIdsByValue(@NotNull Q path, @NotEmpty Collection<P> value) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.getIdPath()).from(this.qModel)).where((Predicate)this.fieldIn(path, value))).fetch();
    }

    protected <P, Q extends Path<P>> boolean updateValue(@NotNull Q path, P value, long id) {
        return this.jpaQueryFactory.update(this.qModel).set(path, value).where(new Predicate[]{this.getIdPath().eq((Object)id)}).execute() > 0L;
    }

    protected <P, Q extends Path<P>, X, Y extends Path<X>> boolean updateValueByValue(@NotNull Q path, P value, @NotNull Y fieldPath, X fieldValue) {
        return this.jpaQueryFactory.update(this.qModel).set(path, value).where(new Predicate[]{this.fieldEq(fieldPath, fieldValue)}).execute() > 0L;
    }

    protected <P, Q extends Path<P>, X, Y extends Path<X>> boolean updateValueByValue(@NotNull Q path, P value, @NotNull Y fieldPath, @NotEmpty Collection<X> fieldValue) {
        return this.jpaQueryFactory.update(this.qModel).set(path, value).where(new Predicate[]{this.fieldIn(fieldPath, fieldValue)}).execute() > 0L;
    }

    protected <Q, P extends Path<Q>> boolean exists(@NotNull P path, @NotNull Q value) {
        return this.exists(path, value, null);
    }

    protected <Q, P extends Path<Q>> boolean exists(@NotNull P path, @NotNull Q value, boolean includeDeleted) {
        return this.exists(path, value, null, includeDeleted);
    }

    protected <Q, P extends Path<Q>> boolean exists(@NotNull P path, @NotNull Q value, Long excludeId) {
        return this.exists(path, value, excludeId, true);
    }

    protected <Q, P extends Path<Q>> boolean exists(@NotNull P path, @NotNull Q value, Long excludeId, boolean includeDeleted) {
        NumberPath<Long> idPath = this.getIdPath();
        BooleanExpression condition = this.fieldEq(path, value);
        if (excludeId != null) {
            condition = condition.and((Predicate)idPath.ne((Object)excludeId));
        }
        if (!includeDeleted) {
            if (this.qModel instanceof QBaseModel) {
                condition = condition.and((Predicate)this.getDeleteFlagPath().eq((Object)0));
            } else {
                throw new IllegalArgumentException(this.qModel.getMetadata().getName() + "\u6ca1\u6709\u3010delete_flag\u3011\u5b57\u6bb5");
            }
        }
        return ((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(idPath).from(this.qModel)).where((Predicate)condition)).limit(1L)).fetchOne() != null;
    }

    protected PagingVO<T> queryByPageWrap(@NotNull JPAQuery<T> jpaQuery, @NotNull PageRequest pageRequest) {
        long count = jpaQuery.fetchCount();
        if (count == 0L) {
            return PagingVO.empty();
        }
        Sort sort = pageRequest.getSort();
        if (!sort.isUnsorted()) {
            OrderSpecifier[] orders = (OrderSpecifier[])sort.stream().map(o -> new OrderSpecifier(o.isAscending() ? Order.ASC : Order.DESC, this.convertFieldExpression(o.getProperty()))).toArray(OrderSpecifier[]::new);
            jpaQuery.orderBy(orders);
        }
        ((JPAQuery)jpaQuery.offset(pageRequest.getOffset())).limit((long)pageRequest.getPageSize());
        return PagingVO.builder().total(count).records(jpaQuery.fetch()).build();
    }

    protected <U extends Serializable> PagingVO<U> queryByPage(@NotNull JPAQuery<U> jpaQuery, @NotNull PageRequest pageRequest) {
        return this.queryByPage(jpaQuery, pageRequest, null);
    }

    protected <U extends Serializable> PagingVO<U> queryByPage(@NotNull JPAQuery<U> jpaQuery, @NotNull PageRequest pageRequest, OrderSpecifier<?> defaultOrder) {
        PagedList pagedList = ((BlazeJPAQuery)new BlazeJPAQuery(this.entityManager, jpaQuery.getMetadata(), this.criteriaBuilderFactory).orderBy(this.obtainOrders(pageRequest, defaultOrder))).fetchPage((int)pageRequest.getOffset(), pageRequest.getPageSize());
        return PagingVO.builder().total(pagedList.getTotalSize()).records((List)pagedList).build();
    }

    protected PagingVO<T> queryByPage(Predicate condition, @NotNull PageRequest pageRequest) {
        return this.queryByPage(condition, pageRequest, null);
    }

    protected PagingVO<T> queryByPage(Predicate condition, @NotNull PageRequest pageRequest, OrderSpecifier<?> defaultOrder) {
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.qModel).from(this.qModel)).where(condition);
        return this.queryByPage(jpaQuery, pageRequest, defaultOrder);
    }

    protected OrderSpecifier<?>[] obtainOrders(@NotNull PageRequest pageRequest) {
        return this.obtainOrders(pageRequest, null);
    }

    protected OrderSpecifier<?>[] obtainOrders(@NotNull PageRequest pageRequest, OrderSpecifier<?> defaultOrder) {
        Sort sort = pageRequest.getSort();
        defaultOrder = this.normalizeDefaultOrder(defaultOrder);
        if (sort.isUnsorted()) {
            OrderSpecifier[] orderSpecifierArray;
            if (defaultOrder == null) {
                OrderSpecifier[] orderSpecifierArray2 = new OrderSpecifier[1];
                orderSpecifierArray = orderSpecifierArray2;
                orderSpecifierArray2[0] = new OrderSpecifier(Order.DESC, this.getIdPath());
            } else {
                OrderSpecifier[] orderSpecifierArray3 = new OrderSpecifier[2];
                orderSpecifierArray3[0] = defaultOrder;
                orderSpecifierArray = orderSpecifierArray3;
                orderSpecifierArray3[1] = new OrderSpecifier(Order.DESC, this.getIdPath());
            }
            return orderSpecifierArray;
        }
        sort = sort.and(Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"id"}));
        return (OrderSpecifier[])sort.stream().map(o -> new OrderSpecifier(o.isAscending() ? Order.ASC : Order.DESC, this.convertFieldExpression(o.getProperty()))).toArray(OrderSpecifier[]::new);
    }

    protected PageRequest ofPage(Integer page, Integer pageSize) {
        return this.ofPage(page, pageSize, Sort.unsorted());
    }

    protected PageRequest ofPage(Integer page, Integer pageSize, Sort sort) {
        if (page == null || page < 0) {
            page = 0;
        }
        if (pageSize == null || pageSize < 0) {
            pageSize = 10;
        }
        if (sort == null) {
            sort = Sort.unsorted();
        }
        return PageRequest.of((int)page, (int)pageSize, (Sort)sort);
    }

    protected Predicate andPredicate(Predicate oldPredicate, Predicate newPredicate) {
        if (newPredicate == null) {
            return oldPredicate;
        }
        return ExpressionUtils.allOf((Predicate[])new Predicate[]{oldPredicate, newPredicate});
    }

    protected NumberPath<Long> getIdPath() {
        return Expressions.numberPath(Long.class, this.qModel, (String)"id");
    }

    protected NumberPath<Integer> getDeleteFlagPath() {
        return Expressions.numberPath(Integer.class, this.qModel, (String)"deleteFlag");
    }

    private OrderSpecifier<?> normalizeDefaultOrder(OrderSpecifier<?> defaultOrder) {
        if (defaultOrder == null) {
            return null;
        }
        if ("id".equals(((Path)defaultOrder.getTarget()).getMetadata().getElement())) {
            return null;
        }
        return defaultOrder;
    }

    private <P, Q extends Path<P>> BooleanExpression fieldEq(@NotNull Q path, P value) {
        SimpleExpression p = (SimpleExpression)path;
        if (value == null) {
            return p.isNull();
        }
        return p.eq(value);
    }

    private <P, Q extends Path<P>> BooleanExpression fieldIn(@NotNull Q path, Collection<P> values) {
        SimpleExpression p = (SimpleExpression)path;
        return p.in(values);
    }

    private Expression<?> convertFieldExpression(String field) {
        if (this.pathBuilder == null) {
            this.pathBuilder = new PathBuilder(this.qModel.getClass(), this.qModel.getMetadata());
        }
        return this.pathBuilder.get(field);
    }

    @Autowired
    public void setJpaQueryFactory(JPAQueryFactory jpaQueryFactory) {
        this.jpaQueryFactory = jpaQueryFactory;
    }

    @Autowired
    public void setEntityManager(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    @Autowired
    public void setCriteriaBuilderFactory(CriteriaBuilderFactory criteriaBuilderFactory) {
        this.criteriaBuilderFactory = criteriaBuilderFactory;
    }

    public static class PredicateBuilder {
        private final List<Predicate> conditions = new ArrayList<Predicate>();

        private PredicateBuilder() {
        }

        public static PredicateBuilder builder() {
            return new PredicateBuilder();
        }

        public PredicateBuilder and(boolean condition, @NotNull Supplier<Predicate> predicate) {
            if (condition) {
                this.conditions.add(predicate.get());
            }
            return this;
        }

        public <T> PredicateBuilder andEq(@NotNull SimpleExpression<T> expression, T value) {
            if (value instanceof String) {
                if (StringUtils.hasText((String)((String)value))) {
                    this.conditions.add((Predicate)expression.eq(value));
                }
                return this;
            }
            if (value != null) {
                this.conditions.add((Predicate)expression.eq(value));
                return this;
            }
            return this;
        }

        public <T> PredicateBuilder andEq(boolean condition, @NotNull SimpleExpression<T> expression, T value) {
            if (condition) {
                this.conditions.add((Predicate)(value == null ? expression.isNull() : expression.eq(value)));
            }
            return this;
        }

        public <T> PredicateBuilder andEq(boolean condition, @NotNull SimpleExpression<T> expression, @NotNull SubQueryExpression<T> subQuery) {
            if (condition) {
                this.conditions.add((Predicate)expression.eq(subQuery));
            }
            return this;
        }

        public <T> PredicateBuilder andNe(@NotNull SimpleExpression<T> expression, T value) {
            if (value instanceof String) {
                if (StringUtils.hasText((String)((String)value))) {
                    this.conditions.add((Predicate)expression.ne(value));
                }
                return this;
            }
            if (value != null) {
                this.conditions.add((Predicate)expression.ne(value));
                return this;
            }
            return this;
        }

        public <T> PredicateBuilder andNe(boolean condition, @NotNull SimpleExpression<T> expression, T value) {
            if (condition) {
                this.conditions.add((Predicate)(value == null ? expression.isNotNull() : expression.ne(value)));
            }
            return this;
        }

        public <T> PredicateBuilder andNe(boolean condition, @NotNull SimpleExpression<T> expression, @NotNull SubQueryExpression<T> subQuery) {
            if (condition) {
                this.conditions.add((Predicate)expression.ne(subQuery));
            }
            return this;
        }

        public <T> PredicateBuilder andNe(boolean condition, @NotNull SimpleExpression<T> expression, @NotNull Supplier<SubQueryExpression<T>> subQuery) {
            return this.andNe(condition, expression, subQuery.get());
        }

        public <T extends Comparable<?>> PredicateBuilder andLt(@NotNull ComparableExpression<T> expression, @NotNull T value) {
            if (value instanceof String) {
                if (StringUtils.hasText((String)((String)((Object)value)))) {
                    this.conditions.add((Predicate)expression.lt(value));
                }
                return this;
            }
            return this.andLt(value != null, expression, value);
        }

        public <T extends Comparable<?>> PredicateBuilder andLt(boolean condition, @NotNull ComparableExpression<T> expression, @NotNull T value) {
            if (condition) {
                this.conditions.add((Predicate)expression.lt(value));
            }
            return this;
        }

        public <T extends Number> PredicateBuilder andLt(@NotNull NumberExpression<T> expression, @NotNull T value) {
            return this.andLt(value != null, expression, value);
        }

        public <T extends Number> PredicateBuilder andLt(boolean condition, @NotNull NumberExpression<T> expression, @NotNull T value) {
            if (condition) {
                this.conditions.add((Predicate)expression.lt(value));
            }
            return this;
        }

        public <T extends Comparable<?>> PredicateBuilder andLoe(@NotNull ComparableExpression<T> expression, @NotNull T value) {
            if (value instanceof String) {
                if (StringUtils.hasText((String)((String)((Object)value)))) {
                    this.conditions.add((Predicate)expression.loe(value));
                }
                return this;
            }
            return this.andLoe(value != null, expression, value);
        }

        public <T extends Comparable<?>> PredicateBuilder andLoe(boolean condition, @NotNull ComparableExpression<T> expression, @NotNull T value) {
            if (condition) {
                this.conditions.add((Predicate)expression.loe(value));
            }
            return this;
        }

        public <T extends Number> PredicateBuilder andLoe(@NotNull NumberExpression<T> expression, @NotNull T value) {
            return this.andLoe(value != null, expression, value);
        }

        public <T extends Number> PredicateBuilder andLoe(boolean condition, @NotNull NumberExpression<T> expression, @NotNull T value) {
            if (condition) {
                this.conditions.add((Predicate)expression.loe(value));
            }
            return this;
        }

        public <T extends Comparable<?>> PredicateBuilder andGt(@NotNull ComparableExpression<T> expression, @NotNull T value) {
            if (value instanceof String) {
                if (StringUtils.hasText((String)((String)((Object)value)))) {
                    this.conditions.add((Predicate)expression.gt(value));
                }
                return this;
            }
            return this.andGt(value != null, expression, value);
        }

        public <T extends Comparable<?>> PredicateBuilder andGt(boolean condition, @NotNull ComparableExpression<T> expression, @NotNull T value) {
            if (condition) {
                this.conditions.add((Predicate)expression.gt(value));
            }
            return this;
        }

        public <T extends Number> PredicateBuilder andGt(@NotNull NumberExpression<T> expression, @NotNull T value) {
            return this.andGt(value != null, expression, value);
        }

        public <T extends Number> PredicateBuilder andGt(boolean condition, @NotNull NumberExpression<T> expression, @NotNull T value) {
            if (condition) {
                this.conditions.add((Predicate)expression.gt(value));
            }
            return this;
        }

        public <T extends Comparable<?>> PredicateBuilder andGoe(@NotNull ComparableExpression<T> expression, @NotNull T value) {
            if (value instanceof String) {
                if (StringUtils.hasText((String)((String)((Object)value)))) {
                    this.conditions.add((Predicate)expression.goe(value));
                }
                return this;
            }
            return this.andGoe(value != null, expression, value);
        }

        public <T extends Comparable<?>> PredicateBuilder andGoe(boolean condition, @NotNull ComparableExpression<T> expression, @NotNull T value) {
            if (condition) {
                this.conditions.add((Predicate)expression.goe(value));
            }
            return this;
        }

        public <T extends Number> PredicateBuilder andGoe(@NotNull NumberExpression<T> expression, @NotNull T value) {
            return this.andGoe(value != null, expression, value);
        }

        public <T extends Number> PredicateBuilder andGoe(boolean condition, @NotNull NumberExpression<T> expression, @NotNull T value) {
            if (condition) {
                this.conditions.add((Predicate)expression.goe(value));
            }
            return this;
        }

        public <T extends Comparable<?>> PredicateBuilder andAfter(@NotNull TemporalExpression<T> expression, @NotNull T value) {
            return this.andAfter(value != null, expression, value);
        }

        public <T extends Comparable<?>> PredicateBuilder andAfter(boolean condition, @NotNull TemporalExpression<T> expression, @NotNull T value) {
            if (condition) {
                this.conditions.add((Predicate)expression.after(value));
            }
            return this;
        }

        public <T extends Comparable<?>> PredicateBuilder andBefore(@NotNull TemporalExpression<T> expression, @NotNull T value) {
            return this.andBefore(value != null, expression, value);
        }

        public <T extends Comparable<?>> PredicateBuilder andBefore(boolean condition, @NotNull TemporalExpression<T> expression, @NotNull T value) {
            if (condition) {
                this.conditions.add((Predicate)expression.before(value));
            }
            return this;
        }

        public <T extends Comparable<?>> PredicateBuilder andBetween(boolean condition, @NotNull TemporalExpression<T> expression, T start, T end) {
            if (condition) {
                if (start != null && end != null) {
                    this.conditions.add((Predicate)expression.between(start, end));
                    return this;
                }
                if (start != null) {
                    this.conditions.add((Predicate)expression.after(start));
                }
                if (end != null) {
                    this.conditions.add((Predicate)expression.before(end));
                }
            }
            return this;
        }

        public <T> PredicateBuilder andNotNull(boolean condition, @NotNull SimpleExpression<T> expression) {
            if (condition) {
                this.conditions.add((Predicate)expression.isNotNull());
            }
            return this;
        }

        public <T> PredicateBuilder andIsNull(boolean condition, @NotNull SimpleExpression<T> expression) {
            if (condition) {
                this.conditions.add((Predicate)expression.isNull());
            }
            return this;
        }

        public PredicateBuilder andLike(@NotNull StringExpression expression, @NotBlank String value) {
            return this.andLike(StringUtils.hasText((String)value), expression, value);
        }

        public PredicateBuilder andLike(boolean condition, @NotNull StringExpression expression, @NotNull String value) {
            if (condition) {
                this.conditions.add((Predicate)expression.like("%" + value + "%"));
            }
            return this;
        }

        public PredicateBuilder andLike(@NotNull StringExpression[] expressions, @NotNull String value) {
            return this.andLike(StringUtils.hasText((String)value), expressions, value);
        }

        public PredicateBuilder andLike(boolean condition, @NotNull StringExpression[] expressions, @NotNull String value) {
            if (condition) {
                String keyword = "%" + value + "%";
                BooleanExpression exp = null;
                for (StringExpression expression : expressions) {
                    if (expression == null) continue;
                    exp = exp == null ? expression.like(keyword) : exp.or((Predicate)expression.like(keyword));
                }
                this.conditions.add((Predicate)exp);
            }
            return this;
        }

        public PredicateBuilder andLeftLike(@NotNull StringExpression expression, @NotBlank String value) {
            return this.andLeftLike(StringUtils.hasText((String)value), expression, value);
        }

        public PredicateBuilder andLeftLike(boolean condition, @NotNull StringExpression expression, @NotBlank String value) {
            if (condition) {
                this.conditions.add((Predicate)expression.like("%" + value));
            }
            return this;
        }

        public PredicateBuilder andLeftLike(@NotNull StringExpression[] expressions, @NotBlank String value) {
            return this.andLeftLike(StringUtils.hasText((String)value), expressions, value);
        }

        public PredicateBuilder andLeftLike(boolean condition, @NotNull StringExpression[] expressions, @NotBlank String value) {
            if (condition) {
                String keyword = "%" + value;
                BooleanExpression exp = null;
                for (StringExpression expression : expressions) {
                    if (expression == null) continue;
                    exp = exp == null ? expression.like(keyword) : exp.or((Predicate)expression.like(keyword));
                }
                this.conditions.add((Predicate)exp);
            }
            return this;
        }

        public PredicateBuilder andRightLike(@NotNull StringExpression expression, @NotBlank String value) {
            return this.andRightLike(StringUtils.hasText((String)value), expression, value);
        }

        public PredicateBuilder andRightLike(boolean condition, @NotNull StringExpression expression, @NotBlank String value) {
            if (condition) {
                this.conditions.add((Predicate)expression.like(value + "%"));
            }
            return this;
        }

        public PredicateBuilder andRightLike(@NotNull StringExpression[] expressions, @NotBlank String value) {
            return this.andRightLike(StringUtils.hasText((String)value), expressions, value);
        }

        public PredicateBuilder andRightLike(boolean condition, @NotNull StringExpression[] expressions, @NotBlank String value) {
            if (condition) {
                String keyword = value + "%";
                BooleanExpression exp = null;
                for (StringExpression expression : expressions) {
                    if (expression == null) continue;
                    exp = exp == null ? expression.like(keyword) : exp.or((Predicate)expression.like(keyword));
                }
                this.conditions.add((Predicate)exp);
            }
            return this;
        }

        public <T> PredicateBuilder andIn(@NotNull SimpleExpression<T> expression, @NotEmpty Collection<T> value) {
            return this.andIn(CollUtil.isNotEmpty(value), expression, value);
        }

        public <T> PredicateBuilder andIn(boolean condition, @NotNull SimpleExpression<T> expression, @NotEmpty Collection<T> value) {
            if (condition) {
                this.conditions.add((Predicate)expression.in(value));
            }
            return this;
        }

        public <T> PredicateBuilder andIn(boolean condition, @NotNull SimpleExpression<T> expression, @NotNull SubQueryExpression<T> value) {
            if (condition) {
                this.conditions.add((Predicate)expression.in(value));
            }
            return this;
        }

        public <T> PredicateBuilder andIn(boolean condition, @NotNull SimpleExpression<T> expression, @NotNull Supplier<SubQueryExpression<T>> value) {
            return this.andIn(condition, expression, value.get());
        }

        public <T> PredicateBuilder andNotIn(@NotNull SimpleExpression<T> expression, @NotEmpty Collection<T> value) {
            return this.andNotIn(CollUtil.isNotEmpty(value), expression, value);
        }

        public <T> PredicateBuilder andNotIn(boolean condition, @NotNull SimpleExpression<T> expression, @NotEmpty Collection<T> value) {
            if (condition) {
                this.conditions.add((Predicate)expression.notIn(value));
            }
            return this;
        }

        public <T> PredicateBuilder andNotIn(boolean condition, @NotNull SimpleExpression<T> expression, @NotNull SubQueryExpression<T> value) {
            if (condition) {
                this.conditions.add((Predicate)expression.notIn(value));
            }
            return this;
        }

        public <T> PredicateBuilder andNotIn(boolean condition, @NotNull SimpleExpression<T> expression, @NotNull Supplier<SubQueryExpression<T>> value) {
            return this.andNotIn(condition, expression, value.get());
        }

        public PredicateBuilder andOnNotBlank(String field, @NotNull Supplier<Predicate> predicate) {
            if (CharSequenceUtil.isNotBlank((CharSequence)field)) {
                this.conditions.add(predicate.get());
            }
            return this;
        }

        public PredicateBuilder andOnNotNull(Object field, @NotNull Supplier<Predicate> predicate) {
            if (field != null) {
                this.conditions.add(predicate.get());
            }
            return this;
        }

        public PredicateBuilder andOnTrue(Boolean field, @NotNull Supplier<Predicate> predicate) {
            if (field != null && field.booleanValue()) {
                this.conditions.add(predicate.get());
            }
            return this;
        }

        public PredicateBuilder andOnFalse(Boolean field, @NotNull Supplier<Predicate> predicate) {
            if (field != null && !field.booleanValue()) {
                this.conditions.add(predicate.get());
            }
            return this;
        }

        public Predicate build() {
            return ExpressionUtils.allOf(this.conditions);
        }

        public Predicate buildOr() {
            return ExpressionUtils.anyOf(this.conditions);
        }
    }
}

