/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.jpa.config;

import com.blazebit.persistence.Criteria;
import com.blazebit.persistence.CriteriaBuilderFactory;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.authorization.core.SecurityContextUtil;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.time.LocalDateTime;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.springframework.boot.autoconfigure.orm.jpa.HibernatePropertiesCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Scope;

public class HibernateConfig {
    @Bean
    public HibernatePropertiesCustomizer hibernatePropertiesCustomizer() {
        return hibernateProperties -> hibernateProperties.put("hibernate.use_sql_comments", false);
    }

    @Bean
    public JPAQueryFactory jpaQueryFactory(EntityManager em) {
        return new CloudtJPAQueryFactory(em);
    }

    @Bean
    @Scope(value="singleton")
    public CriteriaBuilderFactory criteriaBuilderFactory(EntityManagerFactory entityManagerFactory) {
        return Criteria.getDefault().createCriteriaBuilderFactory(entityManagerFactory);
    }

    static class CloudtJPAQueryFactory
    extends JPAQueryFactory {
        public CloudtJPAQueryFactory(EntityManager entityManager) {
            super(entityManager);
        }

        public JPAUpdateClause update(EntityPath<?> path) {
            JPAUpdateClause clause = super.update(path);
            this.auditForUpdate(path, clause);
            return clause;
        }

        private void auditForUpdate(EntityPath<?> path, JPAUpdateClause clause) {
            if (BaseModel.class.isAssignableFrom(path.getType())) {
                LocalDateTime now = LocalDateTime.now();
                clause.set((Path)Expressions.dateTimePath(LocalDateTime.class, path, (String)"modifyTime"), (Object)now);
                GeneralUserDetails user = SecurityContextUtil.currentUser();
                if (user != null) {
                    clause.set((Path)Expressions.numberPath(Long.class, path, (String)"modifyUserId"), (Object)user.getUserId());
                    clause.set((Path)Expressions.stringPath(path, (String)"updater"), (Object)user.getUsername());
                }
            }
        }
    }
}

