package com.elitescloud.boot.jpa;

import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;

import java.io.Serializable;

/**
 * JPA属性配置.
 *
 * @author Kaiser（wang shao）
 * @date 2023/5/8
 */
@ConfigurationProperties(prefix = CloudtJpaProperties.CONFIG_PREFIX)
public class CloudtJpaProperties {
    public static final String CONFIG_PREFIX = "elitesland.jpa";

    @NestedConfigurationProperty
    private Blaze blaze = new Blaze();

    public Blaze getBlaze() {
        return blaze;
    }

    public void setBlaze(Blaze blaze) {
        this.blaze = blaze;
    }

    /**
     * Blaze属性配置，可参考 <a href="https://persistence.blazebit.com/documentation/1.6/core/manual/en_US/#configuration">属性配置</a>
     */
    public static class Blaze implements Serializable {
        private static final long serialVersionUID = -7987000513223290434L;

        /**
         * 是否将count语句放到select字段中
         */
        private Boolean sizeToCountTransformation = true;

        /**
         * 是否优化表达式
         */
        private Boolean expressionOptimization = true;

        /**
         * 在分页查询时自动生成Id Query
         */
        private Boolean inlineIdQuery = true;

        /**
         * 在分页查询时自动在查询语句中加入count语句
         */
        private Boolean inlineCountQuery = true;

        /**
         * 查询计划缓存
         */
        private Boolean queryPlanCacheEnabled = true;

        /**
         * 反向包装
         */
        private Boolean criteriaNegationWrapper = true;

        public Boolean getSizeToCountTransformation() {
            return sizeToCountTransformation;
        }

        public void setSizeToCountTransformation(Boolean sizeToCountTransformation) {
            this.sizeToCountTransformation = sizeToCountTransformation;
        }

        public Boolean getExpressionOptimization() {
            return expressionOptimization;
        }

        public void setExpressionOptimization(Boolean expressionOptimization) {
            this.expressionOptimization = expressionOptimization;
        }

        public Boolean getInlineIdQuery() {
            return inlineIdQuery;
        }

        public void setInlineIdQuery(Boolean inlineIdQuery) {
            this.inlineIdQuery = inlineIdQuery;
        }

        public Boolean getInlineCountQuery() {
            return inlineCountQuery;
        }

        public void setInlineCountQuery(Boolean inlineCountQuery) {
            this.inlineCountQuery = inlineCountQuery;
        }

        public Boolean getQueryPlanCacheEnabled() {
            return queryPlanCacheEnabled;
        }

        public void setQueryPlanCacheEnabled(Boolean queryPlanCacheEnabled) {
            this.queryPlanCacheEnabled = queryPlanCacheEnabled;
        }

        public Boolean getCriteriaNegationWrapper() {
            return criteriaNegationWrapper;
        }

        public void setCriteriaNegationWrapper(Boolean criteriaNegationWrapper) {
            this.criteriaNegationWrapper = criteriaNegationWrapper;
        }
    }
}
