package com.elitescloud.boot.jpa.common;

import cn.hutool.core.util.ObjectUtil;
import com.elitescloud.boot.context.TenantOrgContext;
import com.elitescloud.cloudt.authorization.core.SecurityContextUtil;
import com.elitescloud.cloudt.common.constant.TenantConstant;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import org.hibernate.Filter;
import org.hibernate.Session;
import org.hibernate.internal.SessionImpl;

/**
 * 实体过滤器处理.
 *
 * @author Kaiser（wang shao）
 * @date 2022/10/16
 */
public class DefaultEntityFilterHandler implements EntityFilterHandler {

    @Override
    public void enableFilter(SessionImpl session) {
        var isUseTenantOrg = ObjectUtil.defaultIfNull(TenantOrgContext.isUseTenantOrg(), true);
        if (!isUseTenantOrg) {
            // 不使用租户组织
            return;
        }

        // 获取要过滤的租户组织
        Long tenantOrgId = TenantOrgContext.getTenantOrg();
        if (tenantOrgId == null) {
            // 上下文没有获取到，则默认取当前用户的
            GeneralUserDetails currentUser = SecurityContextUtil.currentUser();
            if (currentUser != null) {
                tenantOrgId = currentUser.getTenantOrgId();
            }
        }
        if (tenantOrgId == null) {
            return;
        }

        Filter filter = session.unwrap(Session.class).enableFilter(TenantConstant.ENTITY_FILTER_ORG_NAME);
        filter.setParameter("tenant_org_id", tenantOrgId);
    }
}
