package com.elitescloud.boot.jpa.config.tenant;

import com.elitescloud.boot.context.TenantSession;
import com.elitescloud.boot.jpa.common.DefaultEntityFilterHandler;
import com.elitescloud.boot.provider.TenantClientProvider;
import com.elitescloud.cloudt.common.constant.TenantConstant;
import lombok.extern.log4j.Log4j2;
import org.hibernate.Filter;
import org.hibernate.Session;
import org.hibernate.internal.SessionImpl;

/**
 * 租户数据过滤器.
 *
 * @author Kaiser（wang shao）
 * @date 2022/8/15
 */
@Log4j2
public class TenantEntityFilterHandler extends DefaultEntityFilterHandler {

    private final TenantClientProvider tenantClientProvider;

    public TenantEntityFilterHandler(TenantClientProvider tenantClientProvider) {
        this.tenantClientProvider = tenantClientProvider;
    }

    @Override
    public void enableFilter(SessionImpl session) {
        super.enableFilter(session);

        // 获取租户
        if (!tenantClientProvider.enabledTenant()) {
            // 未启用租户
            return;
        }
        if (TenantSession.getNoTenant()) {
            // 不使用租户隔离
            return;
        }

        String tenantId = session.getTenantIdentifier();
        if (tenantId == null) {
            var tenant = tenantClientProvider.getSessionTenant();
            if (tenant != null) {
                tenantId = tenant.getId().toString();
            }
        }
        if (tenantId == null) {
            return;
        }

        // 租户隔离
        Filter filter = session.unwrap(Session.class).enableFilter(TenantConstant.ENTITY_FILTER_NAME);
        try {
            filter.setParameter("tenant_id", Long.parseLong(tenantId));
        } catch (NumberFormatException e) {
            log.error("租户ID-{}应为Long类型", tenantId);
            throw new IllegalArgumentException("租户ID应为Long类型", e);
        }
    }
}
