package com.elitescloud.cloudt.core.common;

import com.elitescloud.boot.model.entity.BaseTreeModel;
import com.querydsl.core.types.dsl.EntityPathBase;
import lombok.extern.log4j.Log4j2;

import javax.validation.constraints.NotNull;

/**
 * 树形model的RepoProc类.
 * <p>
 * BaseTreeModel里的信息(除了sortNo外)不可手动维护<p>
 * 在新增业务数据后保存树节点；<p>
 * 如果需要修改节点信息，需要在保存业务数据前修改；<p>
 * 删除节点信息时需要先删除节点，后删除业务数据；<p>
 *
 * @author Kaiser（wang shao）
 * @date 2022/9/29
 * @deprecated 请使用 {@link com.elitescloud.boot.jpa.common.BaseTreeRepoProc}
 */
@Log4j2
@Deprecated(forRemoval = true, since = "3.2.0")
public abstract class BaseTreeRepoProc<T extends BaseTreeModel> extends com.elitescloud.boot.jpa.common.BaseTreeRepoProc<T> {

    protected BaseTreeRepoProc(@NotNull EntityPathBase<T> qModel) {
        super(qModel);
    }
}
