/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.jpa.config;

import com.blazebit.persistence.Criteria;
import com.blazebit.persistence.CriteriaBuilderFactory;
import com.blazebit.persistence.spi.CriteriaBuilderConfiguration;
import com.elitescloud.boot.auth.util.SecurityContextUtil;
import com.elitescloud.boot.jpa.CloudtJpaProperties;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.time.LocalDateTime;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.springframework.boot.autoconfigure.orm.jpa.HibernatePropertiesCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Scope;

public class HibernateConfig {
    private final CloudtJpaProperties jpaProperties;

    public HibernateConfig(CloudtJpaProperties jpaProperties) {
        this.jpaProperties = jpaProperties;
    }

    @Bean
    public HibernatePropertiesCustomizer hibernatePropertiesCustomizer() {
        return hibernateProperties -> hibernateProperties.put("hibernate.use_sql_comments", false);
    }

    @Bean
    public JPAQueryFactory jpaQueryFactory(EntityManager em) {
        return new CloudtJPAQueryFactory(em);
    }

    @Bean
    @Scope(value="singleton")
    public CriteriaBuilderFactory criteriaBuilderFactory(EntityManagerFactory entityManagerFactory) {
        CriteriaBuilderConfiguration criteria = Criteria.getDefault();
        criteria.setProperty("com.blazebit.persistence.size_to_count_transformation", this.jpaProperties.getBlaze().getSizeToCountTransformation().toString());
        criteria.setProperty("com.blazebit.persistence.expression_optimization", this.jpaProperties.getBlaze().getExpressionOptimization().toString());
        criteria.setProperty("com.blazebit.persistence.inline_id_query", this.jpaProperties.getBlaze().getInlineIdQuery().toString());
        criteria.setProperty("com.blazebit.persistence.inline_count_query", this.jpaProperties.getBlaze().getInlineCountQuery().toString());
        criteria.setProperty("com.blazebit.persistence.query_plan_cache_enabled", this.jpaProperties.getBlaze().getQueryPlanCacheEnabled().toString());
        criteria.setProperty("com.blazebit.persistence.criteria_negation_wrapper", this.jpaProperties.getBlaze().getCriteriaNegationWrapper().toString());
        return criteria.createCriteriaBuilderFactory(entityManagerFactory);
    }

    static class CloudtJPAQueryFactory
    extends JPAQueryFactory {
        public CloudtJPAQueryFactory(EntityManager entityManager) {
            super(entityManager);
        }

        public JPAUpdateClause update(EntityPath<?> path) {
            JPAUpdateClause clause = super.update(path);
            this.auditForUpdate(path, clause);
            return clause;
        }

        private void auditForUpdate(EntityPath<?> path, JPAUpdateClause clause) {
            if (BaseModel.class.isAssignableFrom(path.getType())) {
                LocalDateTime now = LocalDateTime.now();
                clause.set((Path)Expressions.dateTimePath(LocalDateTime.class, path, (String)"modifyTime"), (Object)now);
                GeneralUserDetails user = SecurityContextUtil.currentUser();
                if (user != null) {
                    clause.set((Path)Expressions.numberPath(Long.class, path, (String)"modifyUserId"), (Object)user.getUserId());
                    clause.set((Path)Expressions.stringPath(path, (String)"updater"), (Object)user.getUsername());
                }
            }
        }
    }
}

