/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.jpa.config.tenant;

import com.elitescloud.boot.context.TenantSession;
import com.elitescloud.boot.jpa.common.DefaultEntityFilterHandler;
import com.elitescloud.boot.provider.TenantClientProvider;
import com.elitescloud.cloudt.system.dto.SysTenantDTO;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hibernate.Filter;
import org.hibernate.Session;
import org.hibernate.internal.SessionImpl;

public class TenantEntityFilterHandler
extends DefaultEntityFilterHandler {
    private static final Logger log = LogManager.getLogger(TenantEntityFilterHandler.class);
    private final TenantClientProvider tenantClientProvider;

    public TenantEntityFilterHandler(TenantClientProvider tenantClientProvider) {
        this.tenantClientProvider = tenantClientProvider;
    }

    @Override
    public void enableFilter(SessionImpl session) {
        SysTenantDTO tenant;
        super.enableFilter(session);
        if (!this.tenantClientProvider.enabledTenant()) {
            return;
        }
        if (TenantSession.getNoTenant()) {
            return;
        }
        String tenantId = session.getTenantIdentifier();
        if (tenantId == null && (tenant = this.tenantClientProvider.getSessionTenant()) != null) {
            tenantId = tenant.getId().toString();
        }
        if (tenantId == null) {
            return;
        }
        Filter filter = ((Session)session.unwrap(Session.class)).enableFilter("filterByTenantId");
        try {
            filter.setParameter("tenant_id", (Object)Long.parseLong(tenantId));
        }
        catch (NumberFormatException e) {
            log.error("\u79df\u6237ID-{}\u5e94\u4e3aLong\u7c7b\u578b", (Object)tenantId);
            throw new IllegalArgumentException("\u79df\u6237ID\u5e94\u4e3aLong\u7c7b\u578b", e);
        }
    }
}

