/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.jpa.config;

import com.blazebit.persistence.Criteria;
import com.blazebit.persistence.CriteriaBuilderFactory;
import com.blazebit.persistence.spi.CriteriaBuilderConfiguration;
import com.elitescloud.boot.jpa.CloudtJpaProperties;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.boot.provider.CurrentUserProvider;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.time.LocalDateTime;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.orm.jpa.HibernatePropertiesCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Scope;

public class HibernateConfig {
    private final CloudtJpaProperties jpaProperties;

    public HibernateConfig(CloudtJpaProperties jpaProperties) {
        this.jpaProperties = jpaProperties;
    }

    @Bean
    public HibernatePropertiesCustomizer hibernatePropertiesCustomizer() {
        return hibernateProperties -> {
            hibernateProperties.putIfAbsent("hibernate.use_sql_comments", false);
            hibernateProperties.putIfAbsent("hibernate.schema_update.unique_constraint_strategy", "RECREATE_QUIETLY");
            hibernateProperties.putIfAbsent("hibernate.jdbc.batch_size", 50);
            hibernateProperties.putIfAbsent("hibernate.order_inserts", "true");
            hibernateProperties.putIfAbsent("hibernate.order_updates", "true");
            hibernateProperties.putIfAbsent("hibernate.jdbc.batch_versioned_data", "true");
        };
    }

    @Bean
    public JPAQueryFactory jpaQueryFactory(EntityManager em, ObjectProvider<CurrentUserProvider> userProvider) {
        return new CloudtJPAQueryFactory(em, (CurrentUserProvider)userProvider.getIfAvailable());
    }

    @Bean
    @Scope(value="singleton")
    public CriteriaBuilderFactory criteriaBuilderFactory(EntityManagerFactory entityManagerFactory) {
        CriteriaBuilderConfiguration criteria = Criteria.getDefault();
        criteria.setProperty("com.blazebit.persistence.compatible_mode", this.jpaProperties.getBlaze().getCompatibleMode().toString());
        criteria.setProperty("com.blazebit.persistence.returning_clause_case_sensitive", this.jpaProperties.getBlaze().getReturningClauseCaseSensitive().toString());
        criteria.setProperty("com.blazebit.persistence.size_to_count_transformation", this.jpaProperties.getBlaze().getSizeToCountTransformation().toString());
        criteria.setProperty("com.blazebit.persistence.implicit_group_by_from_select", this.jpaProperties.getBlaze().getImplicitGroupByFromSelect().toString());
        criteria.setProperty("com.blazebit.persistence.implicit_group_by_from_having", this.jpaProperties.getBlaze().getImplicitGroupByFromHaving().toString());
        criteria.setProperty("com.blazebit.persistence.implicit_group_by_from_order_by", this.jpaProperties.getBlaze().getImplicitGroupByFromOrderBy().toString());
        criteria.setProperty("com.blazebit.persistence.expression_optimization", this.jpaProperties.getBlaze().getExpressionOptimization().toString());
        criteria.setProperty("com.blazebit.persistence.expression.cache_class", this.jpaProperties.getBlaze().getCacheClass());
        criteria.setProperty("com.blazebit.persistence.values.filter_nulls", this.jpaProperties.getBlaze().getFilterNulls().toString());
        criteria.setProperty("com.blazebit.persistence.parameter_literal_rendering", this.jpaProperties.getBlaze().getParameterLiteralRendering().toString());
        criteria.setProperty("com.blazebit.persistence.optimized_keyset_predicate_rendering", this.jpaProperties.getBlaze().getOptimizedKeysetPredicateRendering().toString());
        criteria.setProperty("com.blazebit.persistence.inline_id_query", this.jpaProperties.getBlaze().getInlineIdQuery());
        criteria.setProperty("com.blazebit.persistence.inline_count_query", this.jpaProperties.getBlaze().getInlineCountQuery());
        criteria.setProperty("com.blazebit.persistence.inline_ctes", this.jpaProperties.getBlaze().getInlineCtes());
        criteria.setProperty("com.blazebit.persistence.query_plan_cache_enabled", this.jpaProperties.getBlaze().getQueryPlanCacheEnabled().toString());
        criteria.setProperty("com.blazebit.persistence.criteria_negation_wrapper", this.jpaProperties.getBlaze().getCriteriaNegationWrapper().toString());
        criteria.setProperty("com.blazebit.persistence.criteria_value_as_parameter", this.jpaProperties.getBlaze().getCriteriaValueAsParameter().toString());
        return criteria.createCriteriaBuilderFactory(entityManagerFactory);
    }

    static class CloudtJPAQueryFactory
    extends JPAQueryFactory {
        private final CurrentUserProvider userProvider;

        public CloudtJPAQueryFactory(EntityManager entityManager, CurrentUserProvider userProvider) {
            super(entityManager);
            this.userProvider = userProvider;
        }

        public JPAUpdateClause update(EntityPath<?> path) {
            JPAUpdateClause clause = super.update(path);
            this.auditForUpdate(path, clause);
            return clause;
        }

        private void auditForUpdate(EntityPath<?> path, JPAUpdateClause clause) {
            if (BaseModel.class.isAssignableFrom(path.getType())) {
                GeneralUserDetails user;
                LocalDateTime now = LocalDateTime.now();
                clause.set((Path)Expressions.dateTimePath(LocalDateTime.class, path, (String)"modifyTime"), (Object)now);
                GeneralUserDetails generalUserDetails = user = this.userProvider == null ? null : this.userProvider.currentUser();
                if (user != null) {
                    clause.set((Path)Expressions.numberPath(Long.class, path, (String)"modifyUserId"), (Object)user.getUserId());
                    clause.set((Path)Expressions.stringPath(path, (String)"updater"), (Object)user.getUsername());
                }
            }
        }
    }
}

