/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.jpa.config.auditing;

import cn.hutool.core.util.ObjectUtil;
import com.elitescloud.boot.SpringContextHolder;
import com.elitescloud.boot.constant.TenantConstant;
import com.elitescloud.boot.context.TenantOrgContext;
import com.elitescloud.boot.jpa.config.auditing.AuditCustomizer;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.boot.provider.TenantClientProvider;
import com.elitescloud.boot.provider.UserDetailProvider;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitescloud.cloudt.system.dto.SysTenantDTO;
import java.time.LocalDateTime;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.auditing.AuditingHandler;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mapping.context.PersistentEntities;

public class CustomAuditHandler
extends AuditingHandler {
    private static final Logger log = LoggerFactory.getLogger(CustomAuditHandler.class);
    private final boolean defaultSecInitEnable = false;
    private TenantClientProvider tenantClientProvider;
    private UserDetailProvider userProvider;
    private List<AuditCustomizer> customizers;

    public CustomAuditHandler(MappingContext<? extends PersistentEntity<?, ?>, ? extends PersistentProperty<?>> mappingContext) {
        super(mappingContext);
    }

    public CustomAuditHandler(PersistentEntities entities) {
        super(entities);
    }

    public <T> T markCreated(@Nonnull T source) {
        if (source instanceof BaseModel) {
            SysTenantDTO currentTenant;
            BaseModel entity = (BaseModel)source;
            LocalDateTime now = LocalDateTime.now();
            Long currentUserId = 0L;
            String currentUsername = null;
            Object secBuId = null;
            Object secUseId = null;
            Long tenantId = entity.getTenantId();
            Long tenantOrgId = entity.getTenantOrgId();
            Long orgId = (Long)ObjectUtil.defaultIfNull((Object)entity.getBelongOrgId(), (Object)entity.getSecBuId());
            if (tenantId == null && (currentTenant = this.getTenantClientProvider().getSessionTenant()) != null) {
                tenantId = currentTenant.getId();
            }
            GeneralUserDetails user = this.currentUser();
            if (tenantOrgId == null) {
                tenantOrgId = this.obtainTenantOrgId(user);
            }
            if (user != null && user.getUser() != null) {
                currentUserId = user.getUser().getId();
                currentUsername = user.getUsername();
                if (orgId == null) {
                    orgId = user.getOrgId();
                }
            }
            if (entity.getCreateUserId() == null && StringUtils.isBlank((CharSequence)entity.getCreator())) {
                entity.setCreateUserId(currentUserId);
                entity.setCreator(currentUsername);
            }
            if (entity.getCreateTime() == null) {
                entity.setCreateTime(now);
            }
            if (entity.getModifyUserId() == null && StringUtils.isBlank((CharSequence)entity.getUpdater())) {
                entity.setModifyUserId(currentUserId);
                entity.setUpdater(currentUsername);
            }
            if (entity.getModifyTime() == null) {
                entity.setModifyTime(now);
            }
            if (entity.getDeleteFlag() == null) {
                entity.setDeleteFlag(Integer.valueOf(0));
            }
            entity.setTenantId((Long)ObjectUtil.defaultIfNull((Object)tenantId, (Object)TenantConstant.DEFAULT_TENANT_ID));
            entity.setTenantOrgId(tenantOrgId);
            entity.setBelongOrgId(orgId);
        }
        this.getCustomizers().forEach(t -> t.onCreate(source));
        return source;
    }

    public <T> T markModified(@Nonnull T source) {
        if (source instanceof BaseModel) {
            BaseModel entity = (BaseModel)source;
            LocalDateTime now = LocalDateTime.now();
            Long currentUserId = entity.getModifyUserId();
            String currentUsername = entity.getUpdater();
            GeneralUserDetails user = this.currentUser();
            if (user != null && user.getUser() != null) {
                currentUserId = user.getUser().getId();
                currentUsername = user.getUsername();
            }
            entity.setModifyUserId(currentUserId);
            entity.setUpdater(currentUsername);
            entity.setModifyTime(now);
            if (entity.getDeleteFlag() == null) {
                entity.setDeleteFlag(Integer.valueOf(0));
            }
        }
        this.getCustomizers().forEach(t -> t.onUpdate(source));
        return source;
    }

    private Long obtainTenantOrgId(GeneralUserDetails user) {
        Boolean useTenantOrg = TenantOrgContext.isUseTenantOrg();
        if (!((Boolean)ObjectUtil.defaultIfNull((Object)useTenantOrg, (Object)true)).booleanValue()) {
            return null;
        }
        Long tenantOrgId = TenantOrgContext.getTenantOrg();
        if (tenantOrgId != null) {
            return tenantOrgId;
        }
        if (user != null) {
            return user.getTenantOrgId();
        }
        return null;
    }

    private GeneralUserDetails currentUser() {
        if (this.userProvider == null) {
            this.userProvider = (UserDetailProvider)SpringContextHolder.getBean(UserDetailProvider.class);
        }
        return this.userProvider.currentUser();
    }

    public TenantClientProvider getTenantClientProvider() {
        if (this.tenantClientProvider == null) {
            this.tenantClientProvider = (TenantClientProvider)SpringContextHolder.getBean(TenantClientProvider.class);
        }
        return this.tenantClientProvider;
    }

    public List<AuditCustomizer> getCustomizers() {
        if (this.customizers == null) {
            this.customizers = SpringContextHolder.getObjectProvider(AuditCustomizer.class).stream().collect(Collectors.toList());
        }
        return this.customizers;
    }
}

