package com.elitescloud.boot.jpa.config.entity;

import com.elitescloud.boot.jpa.common.DefaultEntityFilterHandler;
import com.elitescloud.boot.jpa.common.EntityFilterHandler;
import com.elitescloud.boot.provider.UserDetailProvider;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;

import javax.persistence.EntityManagerFactory;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2022/10/16
 */
public class EntityConfig {

    @Bean
    @ConditionalOnMissingBean
    public EntityFilterHandler entityFilterHandler(ObjectProvider<UserDetailProvider> userProvider) {
        return new DefaultEntityFilterHandler(userProvider.getIfAvailable());
    }

    @Bean
    public EntityFilterProvider dataFilterConfig(FactoryBean<EntityManagerFactory> entityManagerFactoryFactoryBean,
                                                 ObjectProvider<EntityFilterHandler> entityFilterHandlers) {
        var handler = entityFilterHandlers.getIfAvailable();
        return new EntityFilterProvider(entityManagerFactoryFactoryBean, handler);
    }
}
