package org.hibernate.annotations;

import java.lang.annotation.Retention;
import java.lang.annotation.Target;

import static java.lang.annotation.ElementType.*;
import static java.lang.annotation.RetentionPolicy.RUNTIME;

/**
 * <p>
 * 功能说明:覆盖源码 支持继承
 *  具体源码参见 org.hibernate.annotations#Filters
 * </p>
 *
 * @author roman
 * @since 2022/2/23 5:24 PM
 */
@Target({TYPE, METHOD, FIELD})
@Retention(RUNTIME)
public @interface Filters {
    /**
     * The aggregated filters.
     */
    Filter[] value();
}
